% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_create_sql_injection_match_set}
\alias{wafregional_create_sql_injection_match_set}
\title{Creates a SqlInjectionMatchSet, which you use to allow, block, or count
requests that contain snippets of SQL code in a specified part of web
requests}
\usage{
wafregional_create_sql_injection_match_set(Name, ChangeToken)
}
\arguments{
\item{Name}{[required] A friendly name or description for the SqlInjectionMatchSet that you\'re
creating. You can\'t change \code{Name} after you create the
\code{SqlInjectionMatchSet}.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Creates a SqlInjectionMatchSet, which you use to allow, block, or count
requests that contain snippets of SQL code in a specified part of web
requests. AWS WAF searches for character sequences that are likely to be
malicious strings.
}
\details{
To create and configure a \code{SqlInjectionMatchSet}, perform the following
steps:
\enumerate{
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{CreateSqlInjectionMatchSet} request.
\item Submit a \code{CreateSqlInjectionMatchSet} request.
\item Use \code{GetChangeToken} to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateSqlInjectionMatchSet request.
\item Submit an UpdateSqlInjectionMatchSet request to specify the parts of
web requests in which you want to allow, block, or count malicious
SQL code.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_sql_injection_match_set(
  Name = "string",
  ChangeToken = "string"
)
}
}

\examples{
\dontrun{
# The following example creates a SQL injection match set named
# MySQLInjectionMatchSet.
svc$create_sql_injection_match_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  Name = "MySQLInjectionMatchSet"
)
}

}
\keyword{internal}
