% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_operations.R
\name{cloudhsmv2_create_hsm}
\alias{cloudhsmv2_create_hsm}
\title{Creates a new hardware security module (HSM) in the specified AWS
CloudHSM cluster}
\usage{
cloudhsmv2_create_hsm(ClusterId, AvailabilityZone, IpAddress = NULL)
}
\arguments{
\item{ClusterId}{[required] The identifier (ID) of the HSM's cluster. To find the cluster ID, use
\code{\link[=cloudhsmv2_describe_clusters]{describe_clusters}}.}

\item{AvailabilityZone}{[required] The Availability Zone where you are creating the HSM. To find the
cluster's Availability Zones, use
\code{\link[=cloudhsmv2_describe_clusters]{describe_clusters}}.}

\item{IpAddress}{The HSM's IP address. If you specify an IP address, use an available
address from the subnet that maps to the Availability Zone where you are
creating the HSM. If you don't specify an IP address, one is chosen for
you from that subnet.}
}
\description{
Creates a new hardware security module (HSM) in the specified AWS CloudHSM cluster.

See \url{https://paws-r.github.io/docs/cloudhsmv2/create_hsm.html} for full documentation.
}
\keyword{internal}
