% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_user}
\alias{iam_create_user}
\title{Creates a new IAM user for your Amazon Web Services account}
\usage{
iam_create_user(Path = NULL, UserName, PermissionsBoundary = NULL, Tags = NULL)
}
\arguments{
\item{Path}{The path for the user name. For more information about paths, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{IAM identifiers}
in the \emph{IAM User Guide}.

This parameter is optional. If it is not included, it defaults to a
slash (/).

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\verb{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{UserName}{[required] The name of the user to create.

IAM user, group, role, and policy names must be unique within the
account. Names are not distinguished by case. For example, you cannot
create resources named both "MyResource" and "myresource".}

\item{PermissionsBoundary}{The ARN of the policy that is used to set the permissions boundary for
the user.}

\item{Tags}{A list of tags that you want to attach to the new user. Each tag
consists of a key name and an associated value. For more information
about tagging, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html}{Tagging IAM resources}
in the \emph{IAM User Guide}.

If any one of the tags is invalid or if you exceed the allowed maximum
number of tags, then the entire request fails and the resource is not
created.}
}
\description{
Creates a new IAM user for your Amazon Web Services account.

See \url{https://paws-r.github.io/docs/iam/create_user.html} for full documentation.
}
\keyword{internal}
