% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_list_resource_tags}
\alias{kms_list_resource_tags}
\title{Returns all tags on the specified KMS key}
\usage{
kms_list_resource_tags(KeyId, Limit = NULL, Marker = NULL)
}
\arguments{
\item{KeyId}{[required] Gets tags on the specified KMS key.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{Limit}{Use this parameter to specify the maximum number of items to return.
When this value is present, KMS does not return more than the specified
number of items, but it might return fewer.

This value is optional. If you include a value, it must be between 1 and
50, inclusive. If you do not include a value, it defaults to 50.}

\item{Marker}{Use this parameter in a subsequent request after you receive a response
with truncated results. Set it to the value of \code{NextMarker} from the
truncated response you just received.

Do not attempt to construct this value. Use only the value of
\code{NextMarker} from the truncated response you just received.}
}
\description{
Returns all tags on the specified KMS key.

See \url{https://paws-r.github.io/docs/kms/list_resource_tags.html} for full documentation.
}
\keyword{internal}
