% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_get_id}
\alias{cognitoidentity_get_id}
\title{Generates (or retrieves) a Cognito ID}
\usage{
cognitoidentity_get_id(AccountId = NULL, IdentityPoolId, Logins = NULL)
}
\arguments{
\item{AccountId}{A standard AWS account ID (9+ digits).}

\item{IdentityPoolId}{[required] An identity pool ID in the format REGION:GUID.}

\item{Logins}{A set of optional name-value pairs that map provider names to provider
tokens. The available provider names for \code{Logins} are as follows:
\itemize{
\item Facebook: \code{graph.facebook.com}
\item Amazon Cognito user pool:
\verb{cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID>}, for
example, \verb{cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789}.
\item Google: \code{accounts.google.com}
\item Amazon: \code{www.amazon.com}
\item Twitter: \code{api.twitter.com}
\item Digits: \code{www.digits.com}
}}
}
\description{
Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an implicit linked account.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentity_get_id/} for full documentation.
}
\keyword{internal}
