% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_replace_permission_associations}
\alias{ram_replace_permission_associations}
\title{Updates all resource shares that use a managed permission to a different
managed permission}
\usage{
ram_replace_permission_associations(
  fromPermissionArn,
  fromPermissionVersion = NULL,
  toPermissionArn,
  clientToken = NULL
)
}
\arguments{
\item{fromPermissionArn}{[required] Specifies the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}
of the managed permission that you want to replace.}

\item{fromPermissionVersion}{Specifies that you want to updated the permissions for only those
resource shares that use the specified version of the managed
permission.}

\item{toPermissionArn}{[required] Specifies the ARN of the managed permission that you want to associate
with resource shares in place of the one specified by \code{fromPerssionArn}
and \code{fromPermissionVersion}.

The operation always associates the version that is currently the
default for the specified managed permission.}

\item{clientToken}{Specifies a unique, case-sensitive identifier that you provide to ensure
the idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value.}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an
\code{IdempotentParameterMismatch} error.}
}
\description{
Updates all resource shares that use a managed permission to a different managed permission. This operation always applies the default version of the target managed permission. You can optionally specify that the update applies to only resource shares that currently use a specified version. This enables you to update to the latest version, without changing the which managed permission is used.

See \url{https://www.paws-r-sdk.com/docs/ram_replace_permission_associations/} for full documentation.
}
\keyword{internal}
