% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_tag_resource}
\alias{secretsmanager_tag_resource}
\title{Attaches tags to a secret}
\usage{
secretsmanager_tag_resource(SecretId, Tags)
}
\arguments{
\item{SecretId}{[required] The identifier for the secret to attach tags to. You can specify either
the Amazon Resource Name (ARN) or the friendly name of the secret.

For an ARN, we recommend that you specify a complete ARN rather than a
partial ARN. See \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen}{Finding a secret from a partial ARN}.}

\item{Tags}{[required] The tags to attach to the secret as a JSON text string argument. Each
element in the list consists of a \code{Key} and a \code{Value}.

For storing multiple values, we recommend that you use a JSON text
string argument and specify key/value pairs. For more information, see
\href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html}{Specifying parameter values for the Amazon Web Services CLI}
in the Amazon Web Services CLI User Guide.}
}
\description{
Attaches tags to a secret. Tags consist of a key name and a value. Tags are part of the secret's metadata. They are not associated with specific versions of the secret. This operation appends tags to the existing list of tags.

See \url{https://www.paws-r-sdk.com/docs/secretsmanager_tag_resource/} for full documentation.
}
\keyword{internal}
