# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include accessanalyzer_service.R
NULL

#' Retroactively applies the archive rule to existing findings that meet
#' the archive rule criteria
#'
#' @description
#' Retroactively applies the archive rule to existing findings that meet the archive rule criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_apply_archive_rule/](https://www.paws-r-sdk.com/docs/accessanalyzer_apply_archive_rule/) for full documentation.
#'
#' @param analyzerArn &#91;required&#93; The Amazon resource name (ARN) of the analyzer.
#' @param ruleName &#91;required&#93; The name of the rule to apply.
#' @param clientToken A client token.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_apply_archive_rule
accessanalyzer_apply_archive_rule <- function(analyzerArn, ruleName, clientToken = NULL) {
  op <- new_operation(
    name = "ApplyArchiveRule",
    http_method = "PUT",
    http_path = "/archive-rule",
    paginator = list()
  )
  input <- .accessanalyzer$apply_archive_rule_input(analyzerArn = analyzerArn, ruleName = ruleName, clientToken = clientToken)
  output <- .accessanalyzer$apply_archive_rule_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$apply_archive_rule <- accessanalyzer_apply_archive_rule

#' Cancels the requested policy generation
#'
#' @description
#' Cancels the requested policy generation.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_cancel_policy_generation/](https://www.paws-r-sdk.com/docs/accessanalyzer_cancel_policy_generation/) for full documentation.
#'
#' @param jobId &#91;required&#93; The `JobId` that is returned by the
#' [`start_policy_generation`][accessanalyzer_start_policy_generation]
#' operation. The `JobId` can be used with
#' [`get_generated_policy`][accessanalyzer_get_generated_policy] to
#' retrieve the generated policies or used with
#' [`cancel_policy_generation`][accessanalyzer_cancel_policy_generation] to
#' cancel the policy generation request.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_cancel_policy_generation
accessanalyzer_cancel_policy_generation <- function(jobId) {
  op <- new_operation(
    name = "CancelPolicyGeneration",
    http_method = "PUT",
    http_path = "/policy/generation/{jobId}",
    paginator = list()
  )
  input <- .accessanalyzer$cancel_policy_generation_input(jobId = jobId)
  output <- .accessanalyzer$cancel_policy_generation_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$cancel_policy_generation <- accessanalyzer_cancel_policy_generation

#' Checks whether the specified access isn't allowed by a policy
#'
#' @description
#' Checks whether the specified access isn't allowed by a policy.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_check_access_not_granted/](https://www.paws-r-sdk.com/docs/accessanalyzer_check_access_not_granted/) for full documentation.
#'
#' @param policyDocument &#91;required&#93; The JSON policy document to use as the content for the policy.
#' @param access &#91;required&#93; An access object containing the permissions that shouldn't be granted by
#' the specified policy.
#' @param policyType &#91;required&#93; The type of policy. Identity policies grant permissions to IAM
#' principals. Identity policies include managed and inline policies for
#' IAM roles, users, and groups.
#' 
#' Resource policies grant permissions on Amazon Web Services resources.
#' Resource policies include trust policies for IAM roles and bucket
#' policies for Amazon S3 buckets. You can provide a generic input such as
#' identity policy or resource policy or a specific input such as managed
#' policy or Amazon S3 bucket policy.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_check_access_not_granted
accessanalyzer_check_access_not_granted <- function(policyDocument, access, policyType) {
  op <- new_operation(
    name = "CheckAccessNotGranted",
    http_method = "POST",
    http_path = "/policy/check-access-not-granted",
    paginator = list()
  )
  input <- .accessanalyzer$check_access_not_granted_input(policyDocument = policyDocument, access = access, policyType = policyType)
  output <- .accessanalyzer$check_access_not_granted_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$check_access_not_granted <- accessanalyzer_check_access_not_granted

#' Checks whether new access is allowed for an updated policy when compared
#' to the existing policy
#'
#' @description
#' Checks whether new access is allowed for an updated policy when compared to the existing policy.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_check_no_new_access/](https://www.paws-r-sdk.com/docs/accessanalyzer_check_no_new_access/) for full documentation.
#'
#' @param newPolicyDocument &#91;required&#93; The JSON policy document to use as the content for the updated policy.
#' @param existingPolicyDocument &#91;required&#93; The JSON policy document to use as the content for the existing policy.
#' @param policyType &#91;required&#93; The type of policy to compare. Identity policies grant permissions to
#' IAM principals. Identity policies include managed and inline policies
#' for IAM roles, users, and groups.
#' 
#' Resource policies grant permissions on Amazon Web Services resources.
#' Resource policies include trust policies for IAM roles and bucket
#' policies for Amazon S3 buckets. You can provide a generic input such as
#' identity policy or resource policy or a specific input such as managed
#' policy or Amazon S3 bucket policy.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_check_no_new_access
accessanalyzer_check_no_new_access <- function(newPolicyDocument, existingPolicyDocument, policyType) {
  op <- new_operation(
    name = "CheckNoNewAccess",
    http_method = "POST",
    http_path = "/policy/check-no-new-access",
    paginator = list()
  )
  input <- .accessanalyzer$check_no_new_access_input(newPolicyDocument = newPolicyDocument, existingPolicyDocument = existingPolicyDocument, policyType = policyType)
  output <- .accessanalyzer$check_no_new_access_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$check_no_new_access <- accessanalyzer_check_no_new_access

#' Creates an access preview that allows you to preview IAM Access Analyzer
#' findings for your resource before deploying resource permissions
#'
#' @description
#' Creates an access preview that allows you to preview IAM Access Analyzer findings for your resource before deploying resource permissions.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_create_access_preview/](https://www.paws-r-sdk.com/docs/accessanalyzer_create_access_preview/) for full documentation.
#'
#' @param analyzerArn &#91;required&#93; The [ARN of the account
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' used to generate the access preview. You can only create an access
#' preview for analyzers with an `Account` type and `Active` status.
#' @param configurations &#91;required&#93; Access control configuration for your resource that is used to generate
#' the access preview. The access preview includes findings for external
#' access allowed to the resource with the proposed access control
#' configuration. The configuration must contain exactly one element.
#' @param clientToken A client token.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_create_access_preview
accessanalyzer_create_access_preview <- function(analyzerArn, configurations, clientToken = NULL) {
  op <- new_operation(
    name = "CreateAccessPreview",
    http_method = "PUT",
    http_path = "/access-preview",
    paginator = list()
  )
  input <- .accessanalyzer$create_access_preview_input(analyzerArn = analyzerArn, configurations = configurations, clientToken = clientToken)
  output <- .accessanalyzer$create_access_preview_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$create_access_preview <- accessanalyzer_create_access_preview

#' Creates an analyzer for your account
#'
#' @description
#' Creates an analyzer for your account.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_create_analyzer/](https://www.paws-r-sdk.com/docs/accessanalyzer_create_analyzer/) for full documentation.
#'
#' @param analyzerName &#91;required&#93; The name of the analyzer to create.
#' @param type &#91;required&#93; The type of analyzer to create. Only `ACCOUNT`, `ORGANIZATION`,
#' `ACCOUNT_UNUSED_ACCESS`, and `ORGANIZTAION_UNUSED_ACCESS` analyzers are
#' supported. You can create only one analyzer per account per Region. You
#' can create up to 5 analyzers per organization per Region.
#' @param archiveRules Specifies the archive rules to add for the analyzer. Archive rules
#' automatically archive findings that meet the criteria you define for the
#' rule.
#' @param tags An array of key-value pairs to apply to the analyzer.
#' @param clientToken A client token.
#' @param configuration Specifies the configuration of the analyzer. If the analyzer is an
#' unused access analyzer, the specified scope of unused access is used for
#' the configuration. If the analyzer is an external access analyzer, this
#' field is not used.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_create_analyzer
accessanalyzer_create_analyzer <- function(analyzerName, type, archiveRules = NULL, tags = NULL, clientToken = NULL, configuration = NULL) {
  op <- new_operation(
    name = "CreateAnalyzer",
    http_method = "PUT",
    http_path = "/analyzer",
    paginator = list()
  )
  input <- .accessanalyzer$create_analyzer_input(analyzerName = analyzerName, type = type, archiveRules = archiveRules, tags = tags, clientToken = clientToken, configuration = configuration)
  output <- .accessanalyzer$create_analyzer_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$create_analyzer <- accessanalyzer_create_analyzer

#' Creates an archive rule for the specified analyzer
#'
#' @description
#' Creates an archive rule for the specified analyzer. Archive rules automatically archive new findings that meet the criteria you define when you create the rule.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_create_archive_rule/](https://www.paws-r-sdk.com/docs/accessanalyzer_create_archive_rule/) for full documentation.
#'
#' @param analyzerName &#91;required&#93; The name of the created analyzer.
#' @param ruleName &#91;required&#93; The name of the rule to create.
#' @param filter &#91;required&#93; The criteria for the rule.
#' @param clientToken A client token.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_create_archive_rule
accessanalyzer_create_archive_rule <- function(analyzerName, ruleName, filter, clientToken = NULL) {
  op <- new_operation(
    name = "CreateArchiveRule",
    http_method = "PUT",
    http_path = "/analyzer/{analyzerName}/archive-rule",
    paginator = list()
  )
  input <- .accessanalyzer$create_archive_rule_input(analyzerName = analyzerName, ruleName = ruleName, filter = filter, clientToken = clientToken)
  output <- .accessanalyzer$create_archive_rule_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$create_archive_rule <- accessanalyzer_create_archive_rule

#' Deletes the specified analyzer
#'
#' @description
#' Deletes the specified analyzer. When you delete an analyzer, IAM Access Analyzer is disabled for the account or organization in the current or specific Region. All findings that were generated by the analyzer are deleted. You cannot undo this action.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_delete_analyzer/](https://www.paws-r-sdk.com/docs/accessanalyzer_delete_analyzer/) for full documentation.
#'
#' @param analyzerName &#91;required&#93; The name of the analyzer to delete.
#' @param clientToken A client token.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_delete_analyzer
accessanalyzer_delete_analyzer <- function(analyzerName, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteAnalyzer",
    http_method = "DELETE",
    http_path = "/analyzer/{analyzerName}",
    paginator = list()
  )
  input <- .accessanalyzer$delete_analyzer_input(analyzerName = analyzerName, clientToken = clientToken)
  output <- .accessanalyzer$delete_analyzer_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$delete_analyzer <- accessanalyzer_delete_analyzer

#' Deletes the specified archive rule
#'
#' @description
#' Deletes the specified archive rule.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_delete_archive_rule/](https://www.paws-r-sdk.com/docs/accessanalyzer_delete_archive_rule/) for full documentation.
#'
#' @param analyzerName &#91;required&#93; The name of the analyzer that associated with the archive rule to
#' delete.
#' @param ruleName &#91;required&#93; The name of the rule to delete.
#' @param clientToken A client token.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_delete_archive_rule
accessanalyzer_delete_archive_rule <- function(analyzerName, ruleName, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteArchiveRule",
    http_method = "DELETE",
    http_path = "/analyzer/{analyzerName}/archive-rule/{ruleName}",
    paginator = list()
  )
  input <- .accessanalyzer$delete_archive_rule_input(analyzerName = analyzerName, ruleName = ruleName, clientToken = clientToken)
  output <- .accessanalyzer$delete_archive_rule_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$delete_archive_rule <- accessanalyzer_delete_archive_rule

#' Retrieves information about an access preview for the specified analyzer
#'
#' @description
#' Retrieves information about an access preview for the specified analyzer.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_get_access_preview/](https://www.paws-r-sdk.com/docs/accessanalyzer_get_access_preview/) for full documentation.
#'
#' @param accessPreviewId &#91;required&#93; The unique ID for the access preview.
#' @param analyzerArn &#91;required&#93; The [ARN of the
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' used to generate the access preview.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_get_access_preview
accessanalyzer_get_access_preview <- function(accessPreviewId, analyzerArn) {
  op <- new_operation(
    name = "GetAccessPreview",
    http_method = "GET",
    http_path = "/access-preview/{accessPreviewId}",
    paginator = list()
  )
  input <- .accessanalyzer$get_access_preview_input(accessPreviewId = accessPreviewId, analyzerArn = analyzerArn)
  output <- .accessanalyzer$get_access_preview_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$get_access_preview <- accessanalyzer_get_access_preview

#' Retrieves information about a resource that was analyzed
#'
#' @description
#' Retrieves information about a resource that was analyzed.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_get_analyzed_resource/](https://www.paws-r-sdk.com/docs/accessanalyzer_get_analyzed_resource/) for full documentation.
#'
#' @param analyzerArn &#91;required&#93; The [ARN of the
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' to retrieve information from.
#' @param resourceArn &#91;required&#93; The ARN of the resource to retrieve information about.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_get_analyzed_resource
accessanalyzer_get_analyzed_resource <- function(analyzerArn, resourceArn) {
  op <- new_operation(
    name = "GetAnalyzedResource",
    http_method = "GET",
    http_path = "/analyzed-resource",
    paginator = list()
  )
  input <- .accessanalyzer$get_analyzed_resource_input(analyzerArn = analyzerArn, resourceArn = resourceArn)
  output <- .accessanalyzer$get_analyzed_resource_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$get_analyzed_resource <- accessanalyzer_get_analyzed_resource

#' Retrieves information about the specified analyzer
#'
#' @description
#' Retrieves information about the specified analyzer.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_get_analyzer/](https://www.paws-r-sdk.com/docs/accessanalyzer_get_analyzer/) for full documentation.
#'
#' @param analyzerName &#91;required&#93; The name of the analyzer retrieved.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_get_analyzer
accessanalyzer_get_analyzer <- function(analyzerName) {
  op <- new_operation(
    name = "GetAnalyzer",
    http_method = "GET",
    http_path = "/analyzer/{analyzerName}",
    paginator = list()
  )
  input <- .accessanalyzer$get_analyzer_input(analyzerName = analyzerName)
  output <- .accessanalyzer$get_analyzer_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$get_analyzer <- accessanalyzer_get_analyzer

#' Retrieves information about an archive rule
#'
#' @description
#' Retrieves information about an archive rule.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_get_archive_rule/](https://www.paws-r-sdk.com/docs/accessanalyzer_get_archive_rule/) for full documentation.
#'
#' @param analyzerName &#91;required&#93; The name of the analyzer to retrieve rules from.
#' @param ruleName &#91;required&#93; The name of the rule to retrieve.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_get_archive_rule
accessanalyzer_get_archive_rule <- function(analyzerName, ruleName) {
  op <- new_operation(
    name = "GetArchiveRule",
    http_method = "GET",
    http_path = "/analyzer/{analyzerName}/archive-rule/{ruleName}",
    paginator = list()
  )
  input <- .accessanalyzer$get_archive_rule_input(analyzerName = analyzerName, ruleName = ruleName)
  output <- .accessanalyzer$get_archive_rule_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$get_archive_rule <- accessanalyzer_get_archive_rule

#' Retrieves information about the specified finding
#'
#' @description
#' Retrieves information about the specified finding.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_get_finding/](https://www.paws-r-sdk.com/docs/accessanalyzer_get_finding/) for full documentation.
#'
#' @param analyzerArn &#91;required&#93; The [ARN of the
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' that generated the finding.
#' @param id &#91;required&#93; The ID of the finding to retrieve.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_get_finding
accessanalyzer_get_finding <- function(analyzerArn, id) {
  op <- new_operation(
    name = "GetFinding",
    http_method = "GET",
    http_path = "/finding/{id}",
    paginator = list()
  )
  input <- .accessanalyzer$get_finding_input(analyzerArn = analyzerArn, id = id)
  output <- .accessanalyzer$get_finding_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$get_finding <- accessanalyzer_get_finding

#' Retrieves information about the specified finding
#'
#' @description
#' Retrieves information about the specified finding.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_get_finding_v2/](https://www.paws-r-sdk.com/docs/accessanalyzer_get_finding_v2/) for full documentation.
#'
#' @param analyzerArn &#91;required&#93; The [ARN of the
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' that generated the finding.
#' @param id &#91;required&#93; The ID of the finding to retrieve.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token used for pagination of results returned.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_get_finding_v2
accessanalyzer_get_finding_v2 <- function(analyzerArn, id, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "GetFindingV2",
    http_method = "GET",
    http_path = "/findingv2/{id}",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "findingDetails")
  )
  input <- .accessanalyzer$get_finding_v2_input(analyzerArn = analyzerArn, id = id, maxResults = maxResults, nextToken = nextToken)
  output <- .accessanalyzer$get_finding_v2_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$get_finding_v2 <- accessanalyzer_get_finding_v2

#' Retrieves the policy that was generated using StartPolicyGeneration
#'
#' @description
#' Retrieves the policy that was generated using [`start_policy_generation`][accessanalyzer_start_policy_generation].
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_get_generated_policy/](https://www.paws-r-sdk.com/docs/accessanalyzer_get_generated_policy/) for full documentation.
#'
#' @param jobId &#91;required&#93; The `JobId` that is returned by the
#' [`start_policy_generation`][accessanalyzer_start_policy_generation]
#' operation. The `JobId` can be used with
#' [`get_generated_policy`][accessanalyzer_get_generated_policy] to
#' retrieve the generated policies or used with
#' [`cancel_policy_generation`][accessanalyzer_cancel_policy_generation] to
#' cancel the policy generation request.
#' @param includeResourcePlaceholders The level of detail that you want to generate. You can specify whether
#' to generate policies with placeholders for resource ARNs for actions
#' that support resource level granularity in policies.
#' 
#' For example, in the resource section of a policy, you can receive a
#' placeholder such as `"Resource":"arn:aws:s3:::${BucketName}"` instead of
#' `"*"`.
#' @param includeServiceLevelTemplate The level of detail that you want to generate. You can specify whether
#' to generate service-level policies.
#' 
#' IAM Access Analyzer uses `iam:servicelastaccessed` to identify services
#' that have been used recently to create this service-level template.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_get_generated_policy
accessanalyzer_get_generated_policy <- function(jobId, includeResourcePlaceholders = NULL, includeServiceLevelTemplate = NULL) {
  op <- new_operation(
    name = "GetGeneratedPolicy",
    http_method = "GET",
    http_path = "/policy/generation/{jobId}",
    paginator = list()
  )
  input <- .accessanalyzer$get_generated_policy_input(jobId = jobId, includeResourcePlaceholders = includeResourcePlaceholders, includeServiceLevelTemplate = includeServiceLevelTemplate)
  output <- .accessanalyzer$get_generated_policy_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$get_generated_policy <- accessanalyzer_get_generated_policy

#' Retrieves a list of access preview findings generated by the specified
#' access preview
#'
#' @description
#' Retrieves a list of access preview findings generated by the specified access preview.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_list_access_preview_findings/](https://www.paws-r-sdk.com/docs/accessanalyzer_list_access_preview_findings/) for full documentation.
#'
#' @param accessPreviewId &#91;required&#93; The unique ID for the access preview.
#' @param analyzerArn &#91;required&#93; The [ARN of the
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' used to generate the access.
#' @param filter Criteria to filter the returned findings.
#' @param nextToken A token used for pagination of results returned.
#' @param maxResults The maximum number of results to return in the response.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_list_access_preview_findings
accessanalyzer_list_access_preview_findings <- function(accessPreviewId, analyzerArn, filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAccessPreviewFindings",
    http_method = "POST",
    http_path = "/access-preview/{accessPreviewId}",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "findings")
  )
  input <- .accessanalyzer$list_access_preview_findings_input(accessPreviewId = accessPreviewId, analyzerArn = analyzerArn, filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .accessanalyzer$list_access_preview_findings_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$list_access_preview_findings <- accessanalyzer_list_access_preview_findings

#' Retrieves a list of access previews for the specified analyzer
#'
#' @description
#' Retrieves a list of access previews for the specified analyzer.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_list_access_previews/](https://www.paws-r-sdk.com/docs/accessanalyzer_list_access_previews/) for full documentation.
#'
#' @param analyzerArn &#91;required&#93; The [ARN of the
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' used to generate the access preview.
#' @param nextToken A token used for pagination of results returned.
#' @param maxResults The maximum number of results to return in the response.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_list_access_previews
accessanalyzer_list_access_previews <- function(analyzerArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAccessPreviews",
    http_method = "GET",
    http_path = "/access-preview",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "accessPreviews")
  )
  input <- .accessanalyzer$list_access_previews_input(analyzerArn = analyzerArn, nextToken = nextToken, maxResults = maxResults)
  output <- .accessanalyzer$list_access_previews_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$list_access_previews <- accessanalyzer_list_access_previews

#' Retrieves a list of resources of the specified type that have been
#' analyzed by the specified analyzer
#'
#' @description
#' Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer..
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_list_analyzed_resources/](https://www.paws-r-sdk.com/docs/accessanalyzer_list_analyzed_resources/) for full documentation.
#'
#' @param analyzerArn &#91;required&#93; The [ARN of the
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' to retrieve a list of analyzed resources from.
#' @param resourceType The type of resource.
#' @param nextToken A token used for pagination of results returned.
#' @param maxResults The maximum number of results to return in the response.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_list_analyzed_resources
accessanalyzer_list_analyzed_resources <- function(analyzerArn, resourceType = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAnalyzedResources",
    http_method = "POST",
    http_path = "/analyzed-resource",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "analyzedResources")
  )
  input <- .accessanalyzer$list_analyzed_resources_input(analyzerArn = analyzerArn, resourceType = resourceType, nextToken = nextToken, maxResults = maxResults)
  output <- .accessanalyzer$list_analyzed_resources_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$list_analyzed_resources <- accessanalyzer_list_analyzed_resources

#' Retrieves a list of analyzers
#'
#' @description
#' Retrieves a list of analyzers.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_list_analyzers/](https://www.paws-r-sdk.com/docs/accessanalyzer_list_analyzers/) for full documentation.
#'
#' @param nextToken A token used for pagination of results returned.
#' @param maxResults The maximum number of results to return in the response.
#' @param type The type of analyzer.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_list_analyzers
accessanalyzer_list_analyzers <- function(nextToken = NULL, maxResults = NULL, type = NULL) {
  op <- new_operation(
    name = "ListAnalyzers",
    http_method = "GET",
    http_path = "/analyzer",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "analyzers")
  )
  input <- .accessanalyzer$list_analyzers_input(nextToken = nextToken, maxResults = maxResults, type = type)
  output <- .accessanalyzer$list_analyzers_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$list_analyzers <- accessanalyzer_list_analyzers

#' Retrieves a list of archive rules created for the specified analyzer
#'
#' @description
#' Retrieves a list of archive rules created for the specified analyzer.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_list_archive_rules/](https://www.paws-r-sdk.com/docs/accessanalyzer_list_archive_rules/) for full documentation.
#'
#' @param analyzerName &#91;required&#93; The name of the analyzer to retrieve rules from.
#' @param nextToken A token used for pagination of results returned.
#' @param maxResults The maximum number of results to return in the request.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_list_archive_rules
accessanalyzer_list_archive_rules <- function(analyzerName, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListArchiveRules",
    http_method = "GET",
    http_path = "/analyzer/{analyzerName}/archive-rule",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "archiveRules")
  )
  input <- .accessanalyzer$list_archive_rules_input(analyzerName = analyzerName, nextToken = nextToken, maxResults = maxResults)
  output <- .accessanalyzer$list_archive_rules_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$list_archive_rules <- accessanalyzer_list_archive_rules

#' Retrieves a list of findings generated by the specified analyzer
#'
#' @description
#' Retrieves a list of findings generated by the specified analyzer.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_list_findings/](https://www.paws-r-sdk.com/docs/accessanalyzer_list_findings/) for full documentation.
#'
#' @param analyzerArn &#91;required&#93; The [ARN of the
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' to retrieve findings from.
#' @param filter A filter to match for the findings to return.
#' @param sort The sort order for the findings returned.
#' @param nextToken A token used for pagination of results returned.
#' @param maxResults The maximum number of results to return in the response.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_list_findings
accessanalyzer_list_findings <- function(analyzerArn, filter = NULL, sort = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListFindings",
    http_method = "POST",
    http_path = "/finding",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "findings")
  )
  input <- .accessanalyzer$list_findings_input(analyzerArn = analyzerArn, filter = filter, sort = sort, nextToken = nextToken, maxResults = maxResults)
  output <- .accessanalyzer$list_findings_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$list_findings <- accessanalyzer_list_findings

#' Retrieves a list of findings generated by the specified analyzer
#'
#' @description
#' Retrieves a list of findings generated by the specified analyzer.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_list_findings_v2/](https://www.paws-r-sdk.com/docs/accessanalyzer_list_findings_v2/) for full documentation.
#'
#' @param analyzerArn &#91;required&#93; The [ARN of the
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' to retrieve findings from.
#' @param filter A filter to match for the findings to return.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token used for pagination of results returned.
#' @param sort 
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_list_findings_v2
accessanalyzer_list_findings_v2 <- function(analyzerArn, filter = NULL, maxResults = NULL, nextToken = NULL, sort = NULL) {
  op <- new_operation(
    name = "ListFindingsV2",
    http_method = "POST",
    http_path = "/findingv2",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "findings")
  )
  input <- .accessanalyzer$list_findings_v2_input(analyzerArn = analyzerArn, filter = filter, maxResults = maxResults, nextToken = nextToken, sort = sort)
  output <- .accessanalyzer$list_findings_v2_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$list_findings_v2 <- accessanalyzer_list_findings_v2

#' Lists all of the policy generations requested in the last seven days
#'
#' @description
#' Lists all of the policy generations requested in the last seven days.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_list_policy_generations/](https://www.paws-r-sdk.com/docs/accessanalyzer_list_policy_generations/) for full documentation.
#'
#' @param principalArn The ARN of the IAM entity (user or role) for which you are generating a
#' policy. Use this with `ListGeneratedPolicies` to filter the results to
#' only include results for a specific principal.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token used for pagination of results returned.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_list_policy_generations
accessanalyzer_list_policy_generations <- function(principalArn = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListPolicyGenerations",
    http_method = "GET",
    http_path = "/policy/generation",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "policyGenerations")
  )
  input <- .accessanalyzer$list_policy_generations_input(principalArn = principalArn, maxResults = maxResults, nextToken = nextToken)
  output <- .accessanalyzer$list_policy_generations_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$list_policy_generations <- accessanalyzer_list_policy_generations

#' Retrieves a list of tags applied to the specified resource
#'
#' @description
#' Retrieves a list of tags applied to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/accessanalyzer_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to retrieve tags from.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_list_tags_for_resource
accessanalyzer_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .accessanalyzer$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .accessanalyzer$list_tags_for_resource_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$list_tags_for_resource <- accessanalyzer_list_tags_for_resource

#' Starts the policy generation request
#'
#' @description
#' Starts the policy generation request.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_start_policy_generation/](https://www.paws-r-sdk.com/docs/accessanalyzer_start_policy_generation/) for full documentation.
#'
#' @param policyGenerationDetails &#91;required&#93; Contains the ARN of the IAM entity (user or role) for which you are
#' generating a policy.
#' @param cloudTrailDetails A `CloudTrailDetails` object that contains details about a `Trail` that
#' you want to analyze to generate policies.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully, the subsequent retries with the same client
#' token return the result from the original successful request and they
#' have no additional effect.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_start_policy_generation
accessanalyzer_start_policy_generation <- function(policyGenerationDetails, cloudTrailDetails = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "StartPolicyGeneration",
    http_method = "PUT",
    http_path = "/policy/generation",
    paginator = list()
  )
  input <- .accessanalyzer$start_policy_generation_input(policyGenerationDetails = policyGenerationDetails, cloudTrailDetails = cloudTrailDetails, clientToken = clientToken)
  output <- .accessanalyzer$start_policy_generation_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$start_policy_generation <- accessanalyzer_start_policy_generation

#' Immediately starts a scan of the policies applied to the specified
#' resource
#'
#' @description
#' Immediately starts a scan of the policies applied to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_start_resource_scan/](https://www.paws-r-sdk.com/docs/accessanalyzer_start_resource_scan/) for full documentation.
#'
#' @param analyzerArn &#91;required&#93; The [ARN of the
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' to use to scan the policies applied to the specified resource.
#' @param resourceArn &#91;required&#93; The ARN of the resource to scan.
#' @param resourceOwnerAccount The Amazon Web Services account ID that owns the resource. For most
#' Amazon Web Services resources, the owning account is the account in
#' which the resource was created.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_start_resource_scan
accessanalyzer_start_resource_scan <- function(analyzerArn, resourceArn, resourceOwnerAccount = NULL) {
  op <- new_operation(
    name = "StartResourceScan",
    http_method = "POST",
    http_path = "/resource/scan",
    paginator = list()
  )
  input <- .accessanalyzer$start_resource_scan_input(analyzerArn = analyzerArn, resourceArn = resourceArn, resourceOwnerAccount = resourceOwnerAccount)
  output <- .accessanalyzer$start_resource_scan_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$start_resource_scan <- accessanalyzer_start_resource_scan

#' Adds a tag to the specified resource
#'
#' @description
#' Adds a tag to the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_tag_resource/](https://www.paws-r-sdk.com/docs/accessanalyzer_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to add the tag to.
#' @param tags &#91;required&#93; The tags to add to the resource.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_tag_resource
accessanalyzer_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .accessanalyzer$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .accessanalyzer$tag_resource_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$tag_resource <- accessanalyzer_tag_resource

#' Removes a tag from the specified resource
#'
#' @description
#' Removes a tag from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_untag_resource/](https://www.paws-r-sdk.com/docs/accessanalyzer_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to remove the tag from.
#' @param tagKeys &#91;required&#93; The key for the tag to add.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_untag_resource
accessanalyzer_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .accessanalyzer$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .accessanalyzer$untag_resource_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$untag_resource <- accessanalyzer_untag_resource

#' Updates the criteria and values for the specified archive rule
#'
#' @description
#' Updates the criteria and values for the specified archive rule.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_update_archive_rule/](https://www.paws-r-sdk.com/docs/accessanalyzer_update_archive_rule/) for full documentation.
#'
#' @param analyzerName &#91;required&#93; The name of the analyzer to update the archive rules for.
#' @param ruleName &#91;required&#93; The name of the rule to update.
#' @param filter &#91;required&#93; A filter to match for the rules to update. Only rules that match the
#' filter are updated.
#' @param clientToken A client token.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_update_archive_rule
accessanalyzer_update_archive_rule <- function(analyzerName, ruleName, filter, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateArchiveRule",
    http_method = "PUT",
    http_path = "/analyzer/{analyzerName}/archive-rule/{ruleName}",
    paginator = list()
  )
  input <- .accessanalyzer$update_archive_rule_input(analyzerName = analyzerName, ruleName = ruleName, filter = filter, clientToken = clientToken)
  output <- .accessanalyzer$update_archive_rule_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$update_archive_rule <- accessanalyzer_update_archive_rule

#' Updates the status for the specified findings
#'
#' @description
#' Updates the status for the specified findings.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_update_findings/](https://www.paws-r-sdk.com/docs/accessanalyzer_update_findings/) for full documentation.
#'
#' @param analyzerArn &#91;required&#93; The [ARN of the
#' analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources)
#' that generated the findings to update.
#' @param status &#91;required&#93; The state represents the action to take to update the finding Status.
#' Use `ARCHIVE` to change an Active finding to an Archived finding. Use
#' `ACTIVE` to change an Archived finding to an Active finding.
#' @param ids The IDs of the findings to update.
#' @param resourceArn The ARN of the resource identified in the finding.
#' @param clientToken A client token.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_update_findings
accessanalyzer_update_findings <- function(analyzerArn, status, ids = NULL, resourceArn = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateFindings",
    http_method = "PUT",
    http_path = "/finding",
    paginator = list()
  )
  input <- .accessanalyzer$update_findings_input(analyzerArn = analyzerArn, status = status, ids = ids, resourceArn = resourceArn, clientToken = clientToken)
  output <- .accessanalyzer$update_findings_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$update_findings <- accessanalyzer_update_findings

#' Requests the validation of a policy and returns a list of findings
#'
#' @description
#' Requests the validation of a policy and returns a list of findings. The findings help you identify issues and provide actionable recommendations to resolve the issue and enable you to author functional policies that meet security best practices.
#'
#' See [https://www.paws-r-sdk.com/docs/accessanalyzer_validate_policy/](https://www.paws-r-sdk.com/docs/accessanalyzer_validate_policy/) for full documentation.
#'
#' @param locale The locale to use for localizing the findings.
#' @param maxResults The maximum number of results to return in the response.
#' @param nextToken A token used for pagination of results returned.
#' @param policyDocument &#91;required&#93; The JSON policy document to use as the content for the policy.
#' @param policyType &#91;required&#93; The type of policy to validate. Identity policies grant permissions to
#' IAM principals. Identity policies include managed and inline policies
#' for IAM roles, users, and groups.
#' 
#' Resource policies grant permissions on Amazon Web Services resources.
#' Resource policies include trust policies for IAM roles and bucket
#' policies for Amazon S3 buckets. You can provide a generic input such as
#' identity policy or resource policy or a specific input such as managed
#' policy or Amazon S3 bucket policy.
#' 
#' Service control policies (SCPs) are a type of organization policy
#' attached to an Amazon Web Services organization, organizational unit
#' (OU), or an account.
#' @param validatePolicyResourceType The type of resource to attach to your resource policy. Specify a value
#' for the policy validation resource type only if the policy type is
#' `RESOURCE_POLICY`. For example, to validate a resource policy to attach
#' to an Amazon S3 bucket, you can choose `AWS::S3::Bucket` for the policy
#' validation resource type.
#' 
#' For resource types not supported as valid values, IAM Access Analyzer
#' runs policy checks that apply to all resource policies. For example, to
#' validate a resource policy to attach to a KMS key, do not specify a
#' value for the policy validation resource type and IAM Access Analyzer
#' will run policy checks that apply to all resource policies.
#'
#' @keywords internal
#'
#' @rdname accessanalyzer_validate_policy
accessanalyzer_validate_policy <- function(locale = NULL, maxResults = NULL, nextToken = NULL, policyDocument, policyType, validatePolicyResourceType = NULL) {
  op <- new_operation(
    name = "ValidatePolicy",
    http_method = "POST",
    http_path = "/policy/validation",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "findings")
  )
  input <- .accessanalyzer$validate_policy_input(locale = locale, maxResults = maxResults, nextToken = nextToken, policyDocument = policyDocument, policyType = policyType, validatePolicyResourceType = validatePolicyResourceType)
  output <- .accessanalyzer$validate_policy_output()
  config <- get_config()
  svc <- .accessanalyzer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.accessanalyzer$operations$validate_policy <- accessanalyzer_validate_policy
