% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_update_configuration_policy}
\alias{securityhub_update_configuration_policy}
\title{Updates a configuration policy}
\usage{
securityhub_update_configuration_policy(
  Identifier,
  Name = NULL,
  Description = NULL,
  UpdatedReason = NULL,
  ConfigurationPolicy = NULL
)
}
\arguments{
\item{Identifier}{[required] The Amazon Resource Name (ARN) or universally unique identifier (UUID)
of the configuration policy.}

\item{Name}{The name of the configuration policy. Alphanumeric characters and the
following ASCII characters are permitted: \verb{-, ., !, *, /}.}

\item{Description}{The description of the configuration policy.}

\item{UpdatedReason}{The reason for updating the configuration policy.}

\item{ConfigurationPolicy}{An object that defines how Security Hub is configured. It includes
whether Security Hub is enabled or disabled, a list of enabled security
standards, a list of enabled or disabled security controls, and a list
of custom parameter values for specified controls. If you provide a list
of security controls that are enabled in the configuration policy,
Security Hub disables all other controls (including newly released
controls). If you provide a list of security controls that are disabled
in the configuration policy, Security Hub enables all other controls
(including newly released controls).

When updating a configuration policy, provide a complete list of
standards that you want to enable and a complete list of controls that
you want to enable or disable. The updated configuration replaces the
current configuration.}
}
\description{
Updates a configuration policy. Only the Security Hub delegated administrator can invoke this operation from the home Region.

See \url{https://www.paws-r-sdk.com/docs/securityhub_update_configuration_policy/} for full documentation.
}
\keyword{internal}
