% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifiedpermissions_operations.R
\name{verifiedpermissions_create_policy_store}
\alias{verifiedpermissions_create_policy_store}
\title{Creates a policy store}
\usage{
verifiedpermissions_create_policy_store(
  clientToken = NULL,
  validationSettings,
  description = NULL
)
}
\arguments{
\item{clientToken}{Specifies a unique, case-sensitive ID that you provide to ensure the
idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value.}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an
\code{IdempotentParameterMismatch} error.}

\item{validationSettings}{[required] Specifies the validation setting for this policy store.

Currently, the only valid and required value is \code{Mode}.

We recommend that you turn on \code{STRICT} mode only after you define a
schema. If a schema doesn't exist, then \code{STRICT} mode causes any policy
to fail validation, and Verified Permissions rejects the policy. You can
turn off validation by using the
\code{\link[=verifiedpermissions_update_policy_store]{update_policy_store}}. Then,
when you have a schema defined, use
\code{\link[=verifiedpermissions_update_policy_store]{update_policy_store}} again
to turn validation back on.}

\item{description}{Descriptive text that you can provide to help with identification of the
current policy store.}
}
\description{
Creates a policy store. A policy store is a container for policy resources.

See \url{https://www.paws-r-sdk.com/docs/verifiedpermissions_create_policy_store/} for full documentation.
}
\keyword{internal}
