% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifiedpermissions_operations.R
\name{verifiedpermissions_create_policy_template}
\alias{verifiedpermissions_create_policy_template}
\title{Creates a policy template}
\usage{
verifiedpermissions_create_policy_template(
  clientToken = NULL,
  policyStoreId,
  description = NULL,
  statement
)
}
\arguments{
\item{clientToken}{Specifies a unique, case-sensitive ID that you provide to ensure the
idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value.}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an \code{ConflictException} error.

Verified Permissions recognizes a \code{ClientToken} for eight hours. After
eight hours, the next request with the same parameters performs the
operation again regardless of the value of \code{ClientToken}.}

\item{policyStoreId}{[required] The ID of the policy store in which to create the policy template.}

\item{description}{Specifies a description for the policy template.}

\item{statement}{[required] Specifies the content that you want to use for the new policy template,
written in the Cedar policy language.}
}
\description{
Creates a policy template. A template can use placeholders for the principal and resource. A template must be instantiated into a policy by associating it with specific principals and resources to use for the placeholders. That instantiated policy can then be considered in authorization decisions. The instantiated policy works identically to any other policy, except that it is dynamically linked to the template. If the template changes, then any policies that are linked to that template are immediately updated as well.

See \url{https://www.paws-r-sdk.com/docs/verifiedpermissions_create_policy_template/} for full documentation.
}
\keyword{internal}
