% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_replication}
\alias{s3_put_bucket_replication}
\title{Creates a replication configuration or replaces an existing one}
\usage{
s3_put_bucket_replication(Bucket, ContentMD5, ReplicationConfiguration,
  Token)
}
\arguments{
\item{Bucket}{[required]}

\item{ContentMD5}{The base64-encoded 128-bit MD5 digest of the data. You must use this
header as a message integrity check to verify that the request body was
not corrupted in transit.}

\item{ReplicationConfiguration}{[required]}

\item{Token}{A token that allows Amazon S3 object lock to be enabled for an existing
bucket.}
}
\description{
Creates a replication configuration or replaces an existing one. For
more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/crr.html}{Cross-Region Replication (CRR)} in the
\emph{Amazon S3 Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_bucket_replication(
  Bucket = "string",
  ContentMD5 = "string",
  ReplicationConfiguration = list(
    Role = "string",
    Rules = list(
      list(
        ID = "string",
        Priority = 123,
        Prefix = "string",
        Filter = list(
          Prefix = "string",
          Tag = list(
            Key = "string",
            Value = "string"
          ),
          And = list(
            Prefix = "string",
            Tags = list(
              list(
                Key = "string",
                Value = "string"
              )
            )
          )
        ),
        Status = "Enabled"|"Disabled",
        SourceSelectionCriteria = list(
          SseKmsEncryptedObjects = list(
            Status = "Enabled"|"Disabled"
          )
        ),
        Destination = list(
          Bucket = "string",
          Account = "string",
          StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE",
          AccessControlTranslation = list(
            Owner = "Destination"
          ),
          EncryptionConfiguration = list(
            ReplicaKmsKeyID = "string"
          )
        ),
        DeleteMarkerReplication = list(
          Status = "Enabled"|"Disabled"
        )
      )
    )
  ),
  Token = "string"
)
}
}

\examples{
# The following example sets replication configuration on a bucket.
\donttest{svc$put_bucket_replication(
  Bucket = "examplebucket",
  ReplicationConfiguration = list(
    Role = "arn:aws:iam::123456789012:role/examplerole",
    Rules = list(
      list(
        Destination = list(
          Bucket = "arn:aws:s3:::destinationbucket",
          StorageClass = "STANDARD"
        ),
        Prefix = "",
        Status = "Enabled"
      )
    )
  )
)}

}
\keyword{internal}
