% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_create_snapshot}
\alias{storagegateway_create_snapshot}
\title{Initiates a snapshot of a volume}
\usage{
storagegateway_create_snapshot(VolumeARN, SnapshotDescription, Tags)
}
\arguments{
\item{VolumeARN}{[required] The Amazon Resource Name (ARN) of the volume. Use the ListVolumes
operation to return a list of gateway volumes.}

\item{SnapshotDescription}{[required] Textual description of the snapshot that appears in the Amazon EC2
console, Elastic Block Store snapshots panel in the \strong{Description}
field, and in the AWS Storage Gateway snapshot \strong{Details} pane,
\strong{Description} field}

\item{Tags}{A list of up to 50 tags that can be assigned to a snapshot. Each tag is
a key-value pair.

Valid characters for key and value are letters, spaces, and numbers
representable in UTF-8 format, and the following special characters: + -
= . \\_ : / @. The maximum length of a tag\'s key is 128 characters, and
the maximum length for a tag\'s value is 256.}
}
\description{
Initiates a snapshot of a volume.
}
\details{
AWS Storage Gateway provides the ability to back up point-in-time
snapshots of your data to Amazon Simple Storage (S3) for durable
off-site recovery, as well as import the data to an Amazon Elastic Block
Store (EBS) volume in Amazon Elastic Compute Cloud (EC2). You can take
snapshots of your gateway volume on a scheduled or ad hoc basis. This
API enables you to take ad-hoc snapshot. For more information, see
\href{https://docs.aws.amazon.com/storagegateway/latest/userguide/managing-volumes.html#SchedulingSnapshot}{Editing a Snapshot Schedule}.

In the CreateSnapshot request you identify the volume by providing its
Amazon Resource Name (ARN). You must also provide description for the
snapshot. When AWS Storage Gateway takes the snapshot of specified
volume, the snapshot and description appears in the AWS Storage Gateway
Console. In response, AWS Storage Gateway returns you a snapshot ID. You
can use this snapshot ID to check the snapshot progress or later use it
when you want to create a volume from a snapshot. This operation is only
supported in stored and cached volume gateway type.

To list or delete a snapshot, you must use the Amazon EC2 API. For more
information, see DescribeSnapshots or DeleteSnapshot in the \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Operations.html}{EC2 API reference}.

Volume and snapshot IDs are changing to a longer length ID format. For
more information, see the important note on the
\href{https://docs.aws.amazon.com/storagegateway/latest/APIReference/Welcome.html}{Welcome}
page.
}
\section{Request syntax}{
\preformatted{svc$create_snapshot(
  VolumeARN = "string",
  SnapshotDescription = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
# Initiates an ad-hoc snapshot of a gateway volume.
\donttest{svc$create_snapshot(
  SnapshotDescription = "My root volume snapshot as of 10/03/2017",
  VolumeARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol..."
)}

}
\keyword{internal}
