% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3outposts_service.R
\name{s3outposts}
\alias{s3outposts}
\title{Amazon S3 on Outposts}
\usage{
s3outposts(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon S3 on Outposts provides access to S3 on Outposts operations.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- s3outposts(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=s3outposts_create_endpoint]{create_endpoint} \tab Creates an endpoint and associates it with the specified Outpost\cr
\link[=s3outposts_delete_endpoint]{delete_endpoint} \tab Deletes an endpoint\cr
\link[=s3outposts_list_endpoints]{list_endpoints} \tab Lists endpoints associated with the specified Outpost\cr
\link[=s3outposts_list_outposts_with_s3]{list_outposts_with_s3} \tab Lists the Outposts with S3 on Outposts capacity for your Amazon Web Services account\cr
\link[=s3outposts_list_shared_endpoints]{list_shared_endpoints} \tab Lists all endpoints associated with an Outpost that has been shared by Amazon Web Services Resource Access Manager (RAM)
}
}

\examples{
\dontrun{
svc <- s3outposts()
svc$create_endpoint(
  Foo = 123
)
}

}
