% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{arczonalshift}
\alias{arczonalshift}
\title{AWS ARC - Zonal Shift}
\usage{
arczonalshift(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Welcome to the Zonal Shift API Reference Guide for Amazon Route 53
Application Recovery Controller (Route 53 ARC).

You can start a zonal shift to move traffic for a load balancer resource
away from an Availability Zone to help your application recover quickly
from an impairment in an Availability Zone. For example, you can recover
your application from a developer's bad code deployment or from an
Amazon Web Services infrastructure failure in a single Availability
Zone.

You can also configure zonal autoshift for a load balancer resource.
Zonal autoshift is a capability in Route 53 ARC where Amazon Web
Services shifts away application resource traffic from an Availability
Zone, on your behalf, to help reduce your time to recovery during
events. Amazon Web Services shifts away traffic for resources that are
enabled for zonal autoshift whenever Amazon Web Services determines that
there's an issue in the Availability Zone that could potentially affect
customers.

To ensure that zonal autoshift is safe for your application, you must
also configure practice runs when you enable zonal autoshift for a
resource. Practice runs start weekly zonal shifts for a resource, to
shift traffic for the resource out of an Availability Zone. Practice
runs make sure, on a regular basis, that you have enough capacity in all
the Availability Zones in an Amazon Web Services Region for your
application to continue to operate normally when traffic for a resource
is shifted away from one Availability Zone.

You must prescale resource capacity in all Availability Zones in the
Region where your application is deployed, before you configure practice
runs or enable zonal autoshift for a resource. You should not rely on
scaling on demand when an autoshift or practice run starts.

For more information about using zonal shift and zonal autoshift, see
the \href{https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route53-recovery.html}{Amazon Route 53 Application Recovery Controller Developer Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- arczonalshift(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.networking:arczonalshift_cancel_zonal_shift]{cancel_zonal_shift} \tab Cancel a zonal shift in Amazon Route 53 Application Recovery Controller\cr
\link[paws.networking:arczonalshift_create_practice_run_configuration]{create_practice_run_configuration} \tab A practice run configuration for zonal autoshift is required when you enable zonal autoshift\cr
\link[paws.networking:arczonalshift_delete_practice_run_configuration]{delete_practice_run_configuration} \tab Deletes the practice run configuration for a resource\cr
\link[paws.networking:arczonalshift_get_managed_resource]{get_managed_resource} \tab Get information about a resource that's been registered for zonal shifts with Amazon Route 53 Application Recovery Controller in this Amazon Web Services Region\cr
\link[paws.networking:arczonalshift_list_autoshifts]{list_autoshifts} \tab Returns the active autoshifts for a specified resource\cr
\link[paws.networking:arczonalshift_list_managed_resources]{list_managed_resources} \tab Lists all the resources in your Amazon Web Services account in this Amazon Web Services Region that are managed for zonal shifts in Amazon Route 53 Application Recovery Controller, and information about them\cr
\link[paws.networking:arczonalshift_list_zonal_shifts]{list_zonal_shifts} \tab Lists all active and completed zonal shifts in Amazon Route 53 Application Recovery Controller in your Amazon Web Services account in this Amazon Web Services Region\cr
\link[paws.networking:arczonalshift_start_zonal_shift]{start_zonal_shift} \tab You start a zonal shift to temporarily move load balancer traffic away from an Availability Zone in an Amazon Web Services Region, to help your application recover immediately, for example, from a developer's bad code deployment or from an Amazon Web Services infrastructure failure in a single Availability Zone\cr
\link[paws.networking:arczonalshift_update_practice_run_configuration]{update_practice_run_configuration} \tab Update a practice run configuration to change one or more of the following: add, change, or remove the blocking alarm; change the outcome alarm; or add, change, or remove blocking dates or time windows\cr
\link[paws.networking:arczonalshift_update_zonal_autoshift_configuration]{update_zonal_autoshift_configuration} \tab You can update the zonal autoshift status for a resource, to enable or disable zonal autoshift\cr
\link[paws.networking:arczonalshift_update_zonal_shift]{update_zonal_shift} \tab Update an active zonal shift in Amazon Route 53 Application Recovery Controller in your Amazon Web Services account
}
}

\examples{
\dontrun{
svc <- arczonalshift()
svc$cancel_zonal_shift(
  Foo = 123
)
}

}
