% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{responseCurve}
\alias{responseCurve}
\title{Produce data suitable for plotting item response curves}
\usage{
responseCurve(dl, fit, responseNames, item = dl$nameInfo$item,
  samples = 100, from = -6, to = -from, by = 0.1)
}
\arguments{
\item{dl}{a data list prepared by \code{\link{prepData}}}

\item{fit}{a \code{\link[rstan:stanfit-class]{stanfit}} object}

\item{responseNames}{a vector of labels for the possible responses}

\item{item}{a vector of item names}

\item{samples}{number of posterior samples}

\item{from}{the starting latent difference value}

\item{to}{the ending latent difference value}

\item{by}{the grid increment}
}
\value{
A data.frame with the following columns:
\describe{
\item{response}{Which response}
\item{worthDiff}{Difference in worth}
\item{item}{Which item}
\item{sample}{Which sample}
\item{prob}{Associated probability}
\item{responseSample}{A grouping index for independent item response samples}
}
}
\description{
Selects \code{samples} random draws from the posterior and evaluates the item
response curve on the grid given by \code{seq(from,to,by)}.
All items use the same \code{responseNames}. If you have some items
with a different number of thresholds or different response names
then you can call \code{responseCurve} for each item separately
and \code{rbind} the results together.
}
\details{
The paired comparison item response model has thresholds and a
scale parameter similar to the partial credit model (Masters,
1982). The model is cumbersome to describe in traditional
mathematical notation, but the R code is fairly straightforward,

\preformatted{
softmax <- function(y) exp(y) / sum(exp(y))

cmp_probs <- function(scale, alpha, pa1, pa2, thRaw) {
  th <- cumsum(thRaw)
  diff <- scale * (pa2 - pa1)
  unsummed <- c(0, diff + rev(th), diff - th, use.names = FALSE)
  softmax(cumsum(alpha * unsummed))
}
}

The function \code{cmp_probs} takes a \code{scale} constant,
\code{alpha} discrimination, the latent scores for two objects
\code{pa1} and \code{pa2}, and a vector of thresholds
\code{thRaw}. The thresholds are parameterized as the difference
from the previous threshold. For example, thresholds c(0.5, 0.5)
are not at the same location but are at locations c(0.5,
1.0). Thresholds are symmetric. If there is one threshold then the
model admits three possible response outcomes (e.g. win, tie, and
lose). Responses are always stored centered with zero representing
a tie. Therefore, it is necessary to add one plus the number of
thresholds to response data to index into the vector returned by
\code{cmp_probs}. For example, if our response data is (-1, 0, 1)
and has one threshold then we would add 2 (1 + 1 threshold) to
obtain the indices (1, 2, 3).

Use \code{\link{itemModelExplorer}} to explore the item model. In
this \pkg{shiny} app, the \emph{discrimination} parameter does what is
customary in item response models. However, it is not difficult to
show that discrimination is a function of thresholds and
scale. That is, discrimination is not an independent parameter and
cannot be estimated. In paired comparison models, discrimination
and measurement error are confounded.
}
\examples{
\donttest{ vignette('manual', 'pcFactorStan') }
}
\references{
Masters, G. N. (1982). A Rasch model for partial credit scoring.
Psychometrika, 47, 149–174. doi: 10.1007/BF02296272
}
\seealso{
Other data extractor: \code{\link{parDistributionCustom}},
  \code{\link{parInterval}}
}
\concept{data extractor}
