% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{perp.ln2pl}
\alias{perp.ln2pl}
\title{An object of class "Lines3D":

The line crossing the 3D point \code{P} and perpendicular to the plane spanned by 3D points \code{A}, \code{B}, and \code{C}}
\usage{
perp.ln2pl(P, A, B, C, t)
}
\arguments{
\item{P}{A 3D point through which the straight line passes}

\item{A, B, C}{3D points which determine the plane to which the line passing through point \code{P} would be
perpendicular (i.e. the normal vector of this plane determines the direction of the straight line
passing through \code{P})}

\item{t}{A scalar or a vector of scalars representing the parameter of the coordinates of the line
(for the form: \eqn{x=x_0 + a t}, \eqn{y=y_0 + b t}, and \eqn{z=z_0 + c t}  where \eqn{P=(x_0,y_0,z_0)} and normal vector=(a,b,c))}
}
\value{
A list with the elements
\item{desc}{A description of the line}
\item{mtitle}{The "main" title for the plot of the line}
\item{points}{The input points that determine the line and plane, line crosses point \code{P} and plane is determined
by 3D points \code{A}, \code{B}, and \code{C}.}
\item{pnames}{The names of the input points that determine the line and plane; line would be perpendicular
to the plane.}
\item{vecs}{The point \code{P} and normal vector.}
\item{vec.names}{The names of the point \code{P} and the second entry is "normal vector".}
\item{x,y,z}{The x-, y- and z-coordinates of the point(s) of interest on the line perpendicular to the plane
determined by points \code{A}, \code{B}, and \code{C}.}
\item{tsq}{The scalar or the vector of the parameter in defining each coordinate of the line for the form:
\eqn{x=x_0 + a t}, \eqn{y=y_0 + b t}, and \eqn{z=z_0 + c t} where \eqn{P=(x_0,y_0,z_0)} and normal vector=(a,b,c).}
\item{equation}{Equation of the line passing through point \code{P} and perpendicular to the plane determined by
points \code{A}, \code{B}, and \code{C} (i.e., line is in the direction of the normal vector N of the plane). The line equation
is in the form: \eqn{x=x_0 + a t}, \eqn{y=y_0 + b t}, and \eqn{z=z_0 + c t} where \eqn{P=(x_0,y_0,z_0)} and normal vector=(a,b,c).}
}
\description{
Returns the equation, x-, y-, and z-coordinates of the line crossing 3D point \code{P} and perpendicular to the plane
spanned by 3D points \code{A}, \code{B}, and \code{C} (i.e., the line is in the direction of normal vector of this plane)
with the parameter \code{t} being provided in vector \code{t}.
}
\examples{
\donttest{
P<-c(1,1,1); A<-c(1,10,4); B<-c(1,1,3); C<-c(3,9,12)

cf<-as.numeric(Plane(A,B,C,1,1)$coeff)
a<-cf[1]; b<-cf[2]; c<- -1;

vecs<-rbind(A,c(a,b,c))
pts<-rbind(P,A,B,C)
perp.ln2pl(P,A,B,C,.1)

tr<-range(pts,vecs);
tf<-(tr[2]-tr[1])*.1 #how far to go at the lower and upper ends in the x-coordinate
tsq<-seq(-tf*10-tf,tf*10+tf,l=20)  #try also l=100

pln2pl<-perp.ln2pl(P,A,B,C,tsq)
pln2pl
summary(pln2pl)
plot(pln2pl)

perp.ln2pl(P,A,B,C,c(.1,.2))

xc<-pln2pl$x
yc<-pln2pl$y
zc<-pln2pl$z

zr<-range(zc)
zf<-(zr[2]-zr[1])*.2
Bv<- -c(a,b,c)*zf*5

Dr<-(A+B+C)/3

pts2<-rbind(A,B,C)
xr<-range(pts2[,1],xc); yr<-range(pts2[,2],yc)
xf<-(xr[2]-xr[1])*.1 #how far to go at the lower and upper ends in the x-coordinate
yf<-(yr[2]-yr[1])*.1 #how far to go at the lower and upper ends in the y-coordinate
xs<-seq(xr[1]-xf,xr[2]+xf,l=20)  #try also l=100
ys<-seq(yr[1]-yf,yr[2]+yf,l=20)  #try also l=100

plABC<-Plane(A,B,C,xs,ys)
z.grid<-plABC$z

Xlim<-range(xc,xs,pts[,1])
Ylim<-range(yc,ys,pts[,2])
Zlim<-range(zc,z.grid,pts[,3])

xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]
zd<-Zlim[2]-Zlim[1]

plot3D::persp3D(z = z.grid, x = xs, y = ys, theta =225, phi = 30,
col="lightblue", ticktype = "detailed",
        xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05),zlim=Zlim+zd*c(-.05,.05))
        #plane spanned by points A, B, C
plot3D::lines3D(xc, yc, zc, bty = "g",pch = 20, cex = 2,col="red", ticktype = "detailed",add=TRUE)
plot3D::arrows3D(Dr[1],Dr[2],Dr[3],Dr[1]+Bv[1],Dr[2]+Bv[2],Dr[3]+Bv[3], add=TRUE)
plot3D::points3D(pts[,1],pts[,2],pts[,3],add=TRUE)
plot3D::text3D(pts[,1],pts[,2],pts[,3],labels=c("P","A","B","C"),add=TRUE)
plot3D::arrows3D(P[1],P[2],P[3]-zf,P[1],P[2],P[3],lty=2, add=TRUE)
plot3D::text3D(P[1],P[2],P[3]-zf,labels="initial point",add=TRUE)
plot3D::text3D(P[1],P[2],P[3]+zf/2,labels="P",add=TRUE)
plot3D::arrows3D(Dr[1],Dr[2],Dr[3],Dr[1]+Bv[1]/2,Dr[2]+Bv[2]/2,Dr[3]+Bv[3]/2,lty=2, add=TRUE)
plot3D::text3D(Dr[1]+Bv[1]/2,Dr[2]+Bv[2]/2,Dr[3]+Bv[3]/2,labels="normal vector",add=TRUE)
}
}
\seealso{
\code{\link{Line3D}}, \code{\link{paraline3D}} and \code{\link{perpline}}
}
