% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{angle.str2end}
\alias{angle.str2end}
\title{The angles to draw arcs between two line segments}
\usage{
angle.str2end(a, b, c, radian = TRUE)
}
\arguments{
\item{a, b, c}{Three 2D points which represent the intersecting line segments \eqn{[ba]} and \eqn{[bc]}.}

\item{radian}{A logical argument (default=\code{TRUE}).
If \code{TRUE}, the smaller angle or counter-clockwise angle
between the line segments \eqn{[ba]} and \eqn{[bc]} is provided in radians, else it is provided in degrees.}
}
\value{
A \code{list} with two elements
\item{small.arc.angles}{Angles of \eqn{[ba]} and \eqn{[bc]} with the \eqn{x}-axis so that difference between them
is the smaller angle between \eqn{[ba]} and \eqn{[bc]} }
\item{ccw.arc.angles}{Angles of \eqn{[ba]} and \eqn{[bc]} with the \eqn{x}-axis so that difference between them
is the counter-clockwise angle between \eqn{[ba]} and \eqn{[bc]}}
}
\description{
Gives the two pairs of angles in radians or degrees to draw arcs between two vectors or line segments
for the \code{\link[plotrix]{draw.arc}} function in the \code{plotrix} package.
The angles are provided with respect to the \eqn{x}-axis in the coordinate system.
The line segments are \eqn{[ba]} and \eqn{[bc]} when the argument is given as \code{a,b,c} in the function.

\code{radian} is a logical argument (default=\code{TRUE}) which yields the angle in radians if \code{TRUE}, and in degrees if \code{FALSE}.
The first pair of angles is for drawing arcs in the smaller angle between \eqn{[ba]} and \eqn{[bc]}
and the second pair of angles is for drawing arcs in the counter-clockwise order from \eqn{[ba]} to \eqn{[bc]}.
}
\examples{
\dontrun{
A<-c(.3,.2); B<-c(.6,.3); C<-c(1,1)

pts<-rbind(A,B,C)

Xp<-c(B[1]+max(abs(C[1]-B[1]),abs(A[1]-B[1])),0)

angle.str2end(A,B,C)
angle.str2end(A,B,A)

angle.str2end(A,B,C,radian=FALSE)

#plot of the line segments
ang.rad<-angle.str2end(A,B,C,radian=TRUE); ang.rad
ang.deg<-angle.str2end(A,B,C,radian=FALSE); ang.deg
ang.deg1<-ang.deg$s; ang.deg1
ang.deg2<-ang.deg$c; ang.deg2

rad<-min(Dist(A,B),Dist(B,C))

Xlim<-range(pts[,1],Xp[1],B+Xp,B[1]+c(+rad,-rad))
Ylim<-range(pts[,2],B[2]+c(+rad,-rad))
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

#plot for the smaller arc
plot(pts,pch=1,asp=1,xlab="x",ylab="y",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
L<-rbind(B,B,B); R<-rbind(A,C,B+Xp)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
plotrix::draw.arc(B[1],B[2],radius=.3*rad,angle1=ang.rad$s[1],angle2=ang.rad$s[2])
plotrix::draw.arc(B[1],B[2],radius=.6*rad,angle1=0, angle2=ang.rad$s[1],lty=2,col=2)
plotrix::draw.arc(B[1],B[2],radius=.9*rad,angle1=0,angle2=ang.rad$s[2],col=3)
txt<-rbind(A,B,C)
text(txt+cbind(rep(xd*.02,nrow(txt)),rep(-xd*.02,nrow(txt))),c("A","B","C"))

text(rbind(B)+.5*rad*c(cos(mean(ang.rad$s)),sin(mean(ang.rad$s))),
     paste(abs(round(ang.deg1[2]-ang.deg1[1],2))," degrees",sep=""))
text(rbind(B)+.6*rad*c(cos(ang.rad$s[1]/2),sin(ang.rad$s[1]/2)),paste(round(ang.deg1[1],2)),col=2)
text(rbind(B)+.9*rad*c(cos(ang.rad$s[2]/2),sin(ang.rad$s[2]/2)),paste(round(ang.deg1[2],2)),col=3)

#plot for the counter-clockwise arc
plot(pts,pch=1,asp=1,xlab="x",ylab="y",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
L<-rbind(B,B,B); R<-rbind(A,C,B+Xp)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
plotrix::draw.arc(B[1],B[2],radius=.3*rad,angle1=ang.rad$c[1],angle2=ang.rad$c[2])
plotrix::draw.arc(B[1],B[2],radius=.6*rad,angle1=0, angle2=ang.rad$s[1],lty=2,col=2)
plotrix::draw.arc(B[1],B[2],radius=.9*rad,angle1=0,angle2=ang.rad$s[2],col=3)
txt<-pts
text(txt+cbind(rep(xd*.02,nrow(txt)),rep(-xd*.02,nrow(txt))),c("A","B","C"))

text(rbind(B)+.5*rad*c(cos(mean(ang.rad$c)),sin(mean(ang.rad$c))),
     paste(abs(round(ang.deg2[2]-ang.deg2[1],2))," degrees",sep=""))
text(rbind(B)+.6*rad*c(cos(ang.rad$s[1]/2),sin(ang.rad$s[1]/2)),paste(round(ang.deg1[1],2)),col=2)
text(rbind(B)+.9*rad*c(cos(ang.rad$s[2]/2),sin(ang.rad$s[2]/2)),paste(round(ang.deg1[2],2)),col=3)
}

}
\seealso{
\code{\link{angle3pnts}}
}
\author{
Elvan Ceyhan
}
