% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxExtrema.R
\name{cl2edgesCC_VR}
\alias{cl2edgesCC_VR}
\title{The closest points in a data set to edges in each \eqn{CC}-vertex region in a triangle}
\usage{
cl2edgesCC_VR(Xp, tri)
}
\arguments{
\item{Xp}{A set of 2D points representing the set of data points.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}
}
\value{
A \code{list} with the elements
\item{txt1}{Vertex labels are \eqn{A=1}, \eqn{B=2}, and \eqn{C=3} (correspond to row number in Extremum Points).}
\item{txt2}{A short description of the distances as \code{"Distances to Edges in the Respective
CC-Vertex Regions"}.}
\item{type}{Type of the extrema points}
\item{desc}{A short description of the extrema points}
\item{mtitle}{The \code{"main"} title for the plot of the extrema}
\item{ext}{The extrema points, here, closest points to edges in the respective vertex region.}
\item{ind.ext}{Indices of the extrema points,\code{ext}.}
\item{X}{The input data, \code{Xp}, can be a \code{matrix} or \code{data frame}}
\item{num.points}{The number of data points, i.e., size of \code{Xp}}
\item{supp}{Support of the data points, here, it is \code{tri}}
\item{cent}{The center point used for construction of vertex regions}
\item{ncent}{Name of the center, \code{cent}, it is \code{"CC"} for this function}
\item{regions}{Vertex regions inside the triangle, \code{tri}, provided as a \code{list}}
\item{region.names}{Names of the vertex regions as \code{"vr=1"}, \code{"vr=2"}, and \code{"vr=3"}}
\item{region.centers}{Centers of mass of the vertex regions inside \code{tri}}
\item{dist2ref}{Distances of closest points in the vertex regions to corresponding edges}
}
\description{
An object of class \code{"Extrema"}.
Returns the closest data points among the data set, \code{Xp}, to edge \eqn{j} in \eqn{CC}-vertex region \eqn{j} for \eqn{j=1,2,3}
in the triangle, \code{tri}\eqn{=T(A,B,C)}, where \eqn{CC} stands for circumcenter. Vertex labels are \eqn{A=1}, \eqn{B=2}, and \eqn{C=3},
and corresponding edge labels are \eqn{BC=1}, \eqn{AC=2}, and \eqn{AB=3}.
Function yields \code{NA} if there are no data points in a \eqn{CC}-vertex region.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);

n<-20  #try also n<-100
set.seed(1)
Xp<-runif.tri(n,Tr)$g

Ext<-cl2edgesCC_VR(Xp,Tr)
Ext
summary(Ext)
plot(Ext)

cl2e<-Ext

CC<-circ.cent.tri(Tr);
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

Xlim<-range(Tr[,1],Xp[,1],CC[1])
Ylim<-range(Tr[,2],Xp[,2],CC[2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,asp=1,pch=".",xlab="",ylab="",
main="Closest Points in CC-Vertex Regions \n to the Opposite Edges",
axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)

xc<-Tr[,1]+c(-.02,.02,.02)
yc<-Tr[,2]+c(.02,.02,.04)
txt.str<-c("A","B","C")
text(xc,yc,txt.str)

points(Xp,pch=1,col=1)
L<-matrix(rep(CC,3),ncol=2,byrow=TRUE); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(cl2e$ext,pch=3,col=2)

txt<-rbind(CC,Ds)
xc<-txt[,1]+c(-.04,.04,-.03,0)
yc<-txt[,2]+c(-.05,.04,.06,-.08)
txt.str<-c("CC","D1","D2","D3")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cl2edgesVRbas.tri}}, \code{\link{cl2edgesCM_VR}}, \code{\link{cl2edgesM_VR}},
and \code{\link{cl2edges.std.tri}}
}
\author{
Elvan Ceyhan
}
