% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{arcsCStri}
\alias{arcsCStri}
\title{The arcs of Central Similarity Proximity Catch Digraphs (CS-PCD) for 2D data - one triangle case}
\usage{
arcsCStri(Xp, tri, t, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the CS-PCD.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the triangle \code{tri} or the circumcenter of \code{tri};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.}
}
\value{
A \code{list} with the elements
\item{type}{A description of the type of the digraph}
\item{parameters}{Parameters of the digraph, the center \code{M} used to
construct the edge regions and the expansion parameter \code{t}.}
\item{tess.points}{Points on which the tessellation of the study region is performed, here, tessellation
is the support triangle.}
\item{tess.name}{Name of data set used in tessellation (i.e., vertices of the triangle)}
\item{vertices}{Vertices of the digraph, \code{Xp} points}
\item{vert.name}{Name of the data set which constitute the vertices of the digraph}
\item{S}{Tails (or sources) of the arcs of CS-PCD for 2D data set \code{Xp} as vertices of the digraph}
\item{E}{Heads (or arrow ends) of the arcs of CS-PCD for 2D data set \code{Xp} as vertices of the digraph}
\item{mtitle}{Text for \code{"main"} title in the plot of the digraph}
\item{quant}{Various quantities for the digraph: number of vertices, number of partition points,
number of triangles, number of arcs, and arc density.}
}
\description{
An object of class \code{"PCDs"}.
Returns arcs as tails (or sources) and heads (or arrow ends) for data set \code{Xp} as the vertices
of CS-PCD and related parameters and the quantities of the digraph.

CS proximity regions are constructed with respect to the triangle \code{tri} with expansion
parameter \eqn{t>0}, i.e., arcs may exist for points only inside \code{tri}.
It also provides various descriptions and quantities about the arcs of the CS-PCD
such as number of arcs, arc density, etc.

Edge regions are based on center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of
the triangle \code{tri}; default is \eqn{M=(1,1,1)} i.e., the center of mass of \code{tri}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also M<-c(1.6,1.0)

t<-1.5  #try also t<-2

Arcs<-arcsCStri(Xp,Tr,t,M)
#or try with the default center Arcs<-arcsCStri(Xp,Tr,t); M= (Arcs$param)$c
Arcs
summary(Arcs)
plot(Arcs)

#can add edge regions
L<-rbind(M,M,M); R<-Tr
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

#now we can add the vertex names and annotation
txt<-rbind(Tr,M)
xc<-txt[,1]+c(-.02,.03,.02,.03)
yc<-txt[,2]+c(.02,.02,.03,.06)
txt.str<-c("A","B","C","M")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{arcsCS}}, \code{\link{arcsAStri}} and \code{\link{arcsPEtri}}
}
\author{
Elvan Ceyhan
}
