% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/functions.R
\name{computePCEV}
\alias{computePCEV}
\title{Principal Component of Explained Variance}
\usage{
computePCEV(response, covariate, confounder = NULL, estimation = "all",
  inference = "exact", index = NULL, shrink = FALSE, nperm = 1000,
  Wilks = FALSE)
}
\arguments{
\item{response}{A matrix of response variables.}

\item{covariate}{An array or a data frame of covariates.}

\item{confounder}{An array or data frame of confounders.}

\item{estimation}{Character string specifying which estimation method to use:
\code{"all"} or \code{"block"}. Default value is \code{"all"}.}

\item{inference}{Character string specifying which inference method to use:
\code{"exact"} or \code{"permutation"}. Default value is \code{"exact"}.}

\item{index}{If \code{estimation = "block"}, index is a vector describing the
block to which individual response variables correspond.}

\item{shrink}{Should we use a shrinkage estimate of the residual variance?
Default value is \code{FALSE}..}

\item{nperm}{The number of permutations to perform if \code{inference =
"permutation"}}

\item{Wilks}{Should we use a Wilks test instead of Roy's largest test? This
is only implemented for a single covariates.}
}
\value{
An object of class \code{Pcev} containing the first PCEV, the
  p-value, the estimate of the shrinkage factor, etc.
}
\description{
\code{computePCEV} computes the first PCEV and tests its significance.
}
\details{
This is the main function. It computes the PCEV using either the classical
method or the block approach. A p-value is also computed, testing the
significance of the PCEV.

The p-value is computed using either a permutation approach or an exact test.
The implemented exact tests use Wilks' Lambda (only for a single covariate)
or Roy's Largest Root. The latter uses Johnstone's approximation to the null
distribution. Note that this test is also available for the block approach,
but there is no theoretical guarantee that it works, and the resulting
p-value should therefore be compared to that obtained using a permutation
procedure.
}
\examples{
set.seed(12345)
Y <- matrix(rnorm(100*20), nrow=100)
X <- rnorm(100)
pcev_out <- computePCEV(Y, X)
pcev_out2 <- computePCEV(Y, X, shrink = TRUE)
}
\seealso{
\code{\link{estimatePcev}}
}

