% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiplication_estimation.R
\name{approx_mult_prod}
\alias{approx_mult_prod}
\title{Approximate the covariance of a set of predictors and a product of responses}
\usage{
approx_mult_prod(
  means,
  covs,
  n,
  response,
  predictors,
  responses,
  verbose = FALSE
)
}
\arguments{
\item{means}{a vector of predictor and response means with all response means
at the end of the vector.}

\item{covs}{covariance matrix of all predictors and responses with column
and row order corresponding to the order of \code{means}.}

\item{n}{sample size (an integer).}

\item{response}{a string. Currently supports \code{"binary"} or
\code{"continuous"}.}

\item{predictors, responses}{lists of objects of class \code{predictor} where
each entry corresponds to one predictor/response variable.}

\item{verbose}{logical.}
}
\value{
A list containing the following elements:
    \item{means}{a vector of the (approximated) means of all predictors 
      and the product of responses}
    \item{covs}{a matrix of (approximated) covariances between all predictors
      and the product of responses}
}
\description{
\code{approx_mult_prod} recursively estimates the covariances and means of a
  set of responses. Estimates are approximated using all unique response
  orderings and aggregated.
}
\references{
{

  \insertRef{wolf_using_2021}{pcsstools}
  
}
}
