% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_diversity.R
\name{a_diversity}
\alias{a_diversity}
\alias{a_diversity.data.frame}
\alias{a_diversity.pc_otu}
\alias{a_diversity.numeric}
\title{Calculate a_diversity of otutab}
\usage{
a_diversity(otutab, ...)

\method{a_diversity}{data.frame}(
  otutab,
  method = c("richness", "shannon"),
  tree = NULL,
  digits = 4,
  ...
)

\method{a_diversity}{pc_otu}(otutab, method = "all", tbl = "otutab", ...)

\method{a_diversity}{numeric}(otutab, ...)
}
\arguments{
\item{otutab}{numeric}

\item{...}{pass to \code{a_diversity.data.frame}}

\item{method}{one of "all","richness","chao1","ace","gc","shannon","simpson","pd","pielou"}

\item{tree}{a iphylo object match the rownames of otutab}

\item{digits}{maintance how many digits}

\item{tbl}{which table}
}
\value{
a a_res object
}
\description{
Calculate a_diversity of otutab
}
\examples{
data(otutab, package = "pcutils")
a_diversity(otutab) -> a_res
plot(a_res, "Group", metadata)
plot(a_res, "env1", metadata)
}
