% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lead.R
\name{add_lead}
\alias{add_lead}
\title{Add (Select) Leader Experience and Attribute Descriptions (LEAD) Data to Leader-Year or Leader-Dyad-Year Data}
\usage{
add_lead(data, keep)
}
\arguments{
\item{data}{a leader-year or leader-dyad-year data frame}

\item{keep}{an optional parameter, specified as a character vector, about what leader attributes
the user wants to return from this function. If \code{keep} is not specified, everything from the
\code{LEAD} data in this package is returned. Otherwise, the function subsets the \code{LEAD}
data to just what the user wants.}
}
\value{
\code{add_lead()} takes a leader-year or leader-dyad-year data frame and adds some data recorded in the LEAD data to it.
For leader-dyad-year data, suffices of "1" and "2" are added to the data to indicate attributes of the first leader (\code{obsid1})
or the second leader (\code{obsid2}), respectively.
}
\description{
\code{add_lead()} allows you to add some data recorded in the LEAD data to your leader-year or leader-dyad-year data.
}
\examples{

\donttest{
# just call `library(tidyverse)` at the top of the your script
library(magrittr)

create_leaderyears() \%>\% add_lead()

create_leaderyears() \%>\% add_lead(keep = c("yrsexper"))
}

}
\references{
Ellis, Carli Mortenson, Michael C. Horowitz, and Allan C. Stam. 2015. "Introducing the
LEAD Data Set." \emph{International Interactions} 41(4): 718--741.
}
\author{
Steven V. Miller
}
