% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedalfast_factor.R
\docType{data}
\name{gcs}
\alias{gcs}
\alias{gcs_as_integer}
\alias{gcs_as_integer.factor}
\alias{gcs_as_integer.character}
\alias{gcs_as_factor}
\alias{gcs_as_factor.character}
\alias{gcs_as_factor.numeric}
\alias{gcs_ll}
\title{GCS Factor/Integer}
\format{
An object of class \code{list} of length 3.
}
\usage{
gcs_as_integer(x, scale, ...)

\method{gcs_as_integer}{factor}(x, scale, ...)

\method{gcs_as_integer}{character}(x, scale, ...)

gcs_as_factor(x, scale, long_label = FALSE, highest_first = FALSE, ...)

\method{gcs_as_factor}{character}(x, scale, long_label = FALSE, highest_first = FALSE, ...)

\method{gcs_as_factor}{numeric}(x, scale, long_label = FALSE, highest_first = FALSE, ...)

gcs_ll
}
\arguments{
\item{x}{a integer, factor, or character vector.}

\item{scale}{a character string to denote eye, motor, or verbal GCS scale.}

\item{...}{not currently used.}

\item{long_label}{logical to prepend the numeric value to the label of a
factor.}

\item{highest_first}{logical if the factor levels should be ordered with the
highest GCS score as the reference level, else the lowest GCS score as the
reference level.}
}
\value{
\code{gcs_as_factor} returns a factor of equal length to \code{x}.

\code{gcs_as_integer} returns an integer vector of equal length to \code{x}.
}
\description{
Functions for mapping integer values to GCS labeled factor and visa versa
}
\examples{

########################################
# Mapping from numeric values to factor:
nums <- c(0:7, 2.3)

# with short labels
data.frame(nums   = nums,
           eye    = gcs_as_factor(nums, scale = "eye"),
           motor  = gcs_as_factor(nums, scale = "motor"),
           verbal = gcs_as_factor(nums, scale = "verbal"))

# with long labels
data.frame(nums   = nums,
           eye    = gcs_as_factor(nums, scale = "eye", long_label = TRUE),
           motor  = gcs_as_factor(nums, scale = "motor", long_label = TRUE),
           verbal = gcs_as_factor(nums, scale = "verbal", long_label = TRUE))

###################################################
# Mapping from factors/characters to numeric values

# A quick way to access the labels and numeric values
pedalfast.data::gcs_ll

all_levels <- do.call(c, lapply(pedalfast.data::gcs_ll, names))

data.frame(lvls   = all_levels,
           eye    = gcs_as_integer(all_levels, scale = "eye"),
           motor  = gcs_as_integer(all_levels, scale = "motor"),
           verbal = gcs_as_integer(all_levels, scale = "verbal")
           )

##################################################
# Order of the levels:
# The data values are the same, but the order of the levels differs.
gcs_as_factor(1:4, "eye", highest_first = FALSE)
gcs_as_factor(1:4, "eye", highest_first = TRUE)

}
\keyword{datasets}
