% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.R
\name{pedigree}
\alias{pedigree}
\title{Constructor for pedigree objects}
\usage{
pedigree(sire, dam, label)
}
\arguments{
\item{sire}{integer vector or factor representation of the sires}

\item{dam}{integer vector or factor representation of the dams}

\item{label}{character vector of labels}
}
\value{
an pedigree object of class \linkS4class{pedigree}
}
\description{
A simple constructor for a pedigree object.  The main point for the
constructor is to use coercions to make the calls easier.
}
\note{
\code{sire}, \code{dam} and \code{label} must all have the
  same length and all labels in \code{sire} and \code{dam} must occur
  in \code{label}
}
\examples{
ped <- pedigree(sire=c(NA,NA,1,1,4,5), dam=c(NA,NA,2,NA,3,2), label=1:6)
}

