% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.R
\name{getTInv}
\alias{getTInv}
\title{Inverse gene flow from a pedigree}
\usage{
getTInv(ped)
}
\arguments{
\item{ped}{\code{\link{pedigree}}}
}
\value{
matrix (\linkS4class{dtCMatrix} - lower unitriangular sparse)
}
\description{
Get inverse gene flow matrix from a pedigree.
}
\examples{
ped <- pedigree(sire = c(NA, NA, 1,  1, 4, 5),
                dam =  c(NA, NA, 2, NA, 3, 2),
                label = 1:6)
(TInv <- getTInv(ped))

# Test for correctness
TInvExp <- matrix(data = c( 1.0,  0.0,  0.0,  0.0,  0.0,  0.0,
                            0.0,  1.0,  0.0,  0.0,  0.0,  0.0,
                           -0.5, -0.5,  1.0,  0.0,  0.0,  0.0,
                           -0.5,  0.0,  0.0,  1.0,  0.0,  0.0,
                            0.0,  0.0, -0.5, -0.5,  1.0,  0.0,
                            0.0, -0.5,  0.0,  0.0, -0.5,  1.0),
                  byrow = TRUE, nrow = 6)
stopifnot(!any(abs(TInv  - TInvExp) > .Machine$double.eps))
stopifnot(is(TInv, "sparseMatrix"))
}
