% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vgmLags.R
\name{variogramBins}
\alias{variogramBins}
\alias{vgmLags}
\title{Variogram binning}
\usage{
variogramBins(
  coords,
  n.lags = 7,
  type = "exp",
  cutoff = 0.5,
  base = 2,
  zero = 0.001,
  count = "pairs"
)

vgmLags(
  coords,
  n.lags = 7,
  type = "exp",
  cutoff = 0.5,
  base = 2,
  zero = 0.001,
  count = "pairs"
)
}
\arguments{
\item{coords}{Data frame or matrix with the projected x- and y-coordinates.}

\item{n.lags}{Integer value defining the number of variogram bins (distance classes) that should
be computed. Defaults to \code{n = 7}.}

\item{type}{Character value defining the type of variogram bins that should be computed,
with options \code{"equi"} (equidistant, equal-width) and \code{"exp"} (exponential, exponentially
growing). Defaults to \code{type = "exp"}.}

\item{cutoff}{Numeric value defining the fraction of the diagonal of the rectangle that spans the
data (bounding box) that should be used to set the maximum distance up to which variogram bins
should be computed. Defaults to \code{cutoff = 0.5}, i.e. half the diagonal of the bounding box.}

\item{base}{Numeric value defining the base of the exponential expression used to create
exponentially growing variogram bins. Used only when \code{type = "exp"}. Defaults to \code{base = 2},
i.e. the width of the rightmost bin is equal to half the diagonal of \code{cutoff}, and so on.}

\item{zero}{Numeric value setting the minimum pair-wise separation distance that should be used
to compute the variogram bins. Defaults to \code{zero = 0.0001}.}

\item{count}{Should the number of points (\code{"points"}) or point-pairs (\code{"pairs"}) per variogram
bin be computed? Defaults to \code{count = "pairs"}.}
}
\value{
Vector of numeric values with the lower and upper boundaries of the variogram bins. The
number of points or point-pairs per variogram bin is returned as an attribute.
}
\description{
Computation of bins for sample (experimental) variograms.
}
\section{Dependencies}{

The \strong{SpatialTools} package, provider of tools for spatial data analysis in R, is required for
\code{\link[=variogramBins]{variogramBins()}} to work. The development version of the \strong{SpatialTools} package
is available on \url{https://github.com/jfrench/SpatialTools} while its old versions are available
on the CRAN archive at \url{https://cran.r-project.org/src/contrib/Archive/SpatialTools/}.
}

\section{Reverse dependencies}{

The \strong{spsann} package, provider of methods for the optimization of sample configurations using
spatial simulated annealing in R, requires \code{\link[=variogramBins]{variogramBins()}} for some of its
functions to work. The development version of the \strong{spsann} package is available on
\url{https://github.com/Laboratorio-de-Pedometria/spsann-package}.
}

\examples{
if (all(c(require(SpatialTools), require(sp)))) {
  data(meuse, package = "sp")
  lags_points <- variogramBins(coords = meuse[, 1:2], count = "points")
  lags_pairs <- variogramBins(coords = meuse[, 1:2], count = "pairs")
}
}
\references{
Truong, P. N.; Heuvelink, G. B. M.; Gosling, J. P. Web-based tool for expert elicitation of the
variogram. \emph{Computers and Geosciences}. v. 51, p. 390-399, 2013.
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
\concept{variogram}
