% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pq_plot2.R
\name{pq_plot}
\alias{pq_plot}
\title{creating charts for time series}
\usage{
pq_plot(dt, chart_type = "line", x = "date", y = "close", yb = NULL,
  date_range = "max", yaxis_log = FALSE, title = NULL, addti = NULL,
  nsd_lm = NULL, markline = TRUE, orders = NULL, arrange = list(rows =
  NULL, cols = NULL), theme = "default", ...)
}
\arguments{
\item{dt}{a list/dataframe of time series dataset}

\item{chart_type}{chart type, including line, step, candle.}

\item{x}{column name for x axis}

\item{y}{column name for y axis}

\item{yb}{column name for baseline}

\item{date_range}{date range of x axis to display. Available value includes '1m'-'11m', 'ytd', 'max' and '1y'-'ny'. Default is max.}

\item{yaxis_log}{whether to display y axis values in log. Default is FALSE.}

\item{title}{chart title. It will added to the front of chart title if it is specified.}

\item{addti}{list of technical indicators or numerical columns in dt. For technical indicator, it is calculated via \code{pq_addti}, which including overlays and indicators.}

\item{nsd_lm}{number of standard deviation from linear regression fitting values.}

\item{markline}{whether to display markline. Default is TRUE.}

\item{orders}{a data frame of trade orders, which including columns of symbol, date, side, prices, and quantity.}

\item{arrange}{a list. Number of rows and columns charts to connect. Default is NULL.}

\item{theme}{name of echarts theme, see details in \code{\link{e_theme}}}

\item{...}{ignored}
}
\description{
\code{pq_plot} provides an easy way to create interactive charts for time series dataset based on predefined formats.
}
\examples{
\donttest{
# single serie
library(data.table)
library(pedquant)
data(dt_ssec)

# line chart (default)
e1 = pq_plot(dt_ssec, chart_type = 'line') # line chart (default)
e1[[1]]

# add technical indicators
e2 = pq_plot(dt_ssec, addti = list(
        sma = list(n = 200), 
        sma = list(n = 50), 
        volume = list(),
        macd = list()
))
e2[[1]]

# linear trend with yaxis in log
e3 = pq_plot(dt_ssec, nsd_lm = c(-0.8, 0, 0.8), markline=FALSE)
e3[[1]]

# multiple series
data(dt_banks)
setDT(dt_banks)
dt_banksadj = md_stock_adjust(dt_banks)

# linear trend
elist = pq_plot(dt_banksadj)
e4 = pq_plot(dt_banksadj, arrange = list(rows=1, cols=1))
e4[[1]]

# orders 
b2 = dt_banks[symbol \%in\% c('601988.SH', '601398.SH')]
b2orders = b2[sample(.N, 10), .(symbol, date, prices=close, 
              side=sample(c(-1, 1), 10, replace=TRUE))]
                
e5 = pq_plot(b2, orders=b2orders)
e5[[1]]

e6 = pq_plot(b2, orders=b2orders, arrange = list(rows=1, cols=1))
e6[[1]]
}

}
