% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writePed.R
\name{writePed}
\alias{writePed}
\title{Write a pedigree to file}
\usage{
writePed(
  x,
  prefix = famid(x),
  what = c("ped", "map", "dat", "freq"),
  merlin = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \code{ped} object}

\item{prefix}{A character string giving the prefix of the files. For
instance, if \code{prefix = "myped"} and \code{what = c("ped", "map")}, the output
files are "myped.ped" and "myped.map" in the current directory. Paths to
other folder may be included, e.g. \code{prefix = "path-to-my-dir/myped"}. By
default, the family identifier \code{famid(x)} is used. Note that if this is
empty, the files become ".ped" and so on.}

\item{what}{A subset of the character vector c("ped", "map", "dat" and
"freq"), indicating which files should be created. All files are written in
MERLIN style (but see the \code{merlin} parameter below!) By default all files
are created.}

\item{merlin}{A logical. If TRUE, the marker alleles are relabelled to
1,2,..., making sure that the generated files are readable by MERLIN (which
does not accept non-numerical allele labels in the frequency file.) If
FALSE (the default) the allele labels are unchanged. In this case, \code{x}
should be exactly reproducible from the files (see examples).}

\item{verbose}{A logical.}
}
\value{
A character vector with the file names.
}
\description{
Write a pedigree to file
}
\examples{

tmpdir = tempdir()
x = nuclearPed(1)
x = setMarkers(x, marker(x, '3' = 1:2))
writePed(x, prefix = file.path(tmpdir, "myped"))

}
