% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_cluster_bootstrap.R
\name{draw_cluster_bootstrap}
\alias{draw_cluster_bootstrap}
\title{Draw a cluster bootstrap sample from a data frame in long format}
\usage{
draw_cluster_bootstrap(df, idvar, boot.ids)
}
\arguments{
\item{df}{a data frame in long format}

\item{idvar}{name of the subject id in \code{df} (it should be a
numeric id that ranges from 1 to n, without skipping values)}

\item{boot.ids}{identifiers of the subjects to be sampled}
}
\value{
A data frame containing the bootstrapped observations
}
\description{
This function is part of the cluster bootstrap optimism correction
procedure described in Signorelli et al. (2020, in review). Note
that this function does not perform the random sampling, but it
extracts the correct records from a dataframe, given the ids of
the sampled clusters (subjects)
}
\references{
Signorelli, M., Spitali, P., Tsonaka, R. (in review).
On the prediction of survival outcomes using longitudinal
and high-dimensional (omic) data.
}
\author{
Mirko Signorelli
}
