% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stratified_percentile_calculator.R
\name{Stratified_percentile_calculator_generator}
\alias{Stratified_percentile_calculator_generator}
\title{R6 Class representing a compund of data and methods used to calculate stratified percentiles}
\description{
R6 Class representing a compund of data and methods used to calculate stratified percentiles

R6 Class representing a compund of data and methods used to calculate stratified percentiles
}
\details{
A calculator has:
 - raw_data representing the data.frame passed in for calculation
 - result_data an environment containing the result data.frame $data, shared with
 - sub_results representing subordinate steps in recursive calculation process
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{raw_data}}{Return the data.frame originally handed to the object}

\item{\code{result_data}}{Return the environment containing a data.frame (§data) containing results of current hierarchy}

\item{\code{sub_results}}{Return the named list with Stratified_percentile_calculator_generator objects for recursive stacking}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Stratified_percentile_calculator_generator$new()}}
\item \href{#method-divide_and_calculate}{\code{Stratified_percentile_calculator_generator$divide_and_calculate()}}
\item \href{#method-clone}{\code{Stratified_percentile_calculator_generator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new Stratified_percentile_calculator object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stratified_percentile_calculator_generator$new(
  raw_data = NULL,
  result_data = new.env(),
  current_stratification_characteristic = NULL,
  remaining_stratification_characteristics = NULL,
  value_column = NULL,
  output_column = NULL,
  use.na = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw_data}}{data.frame to perform calculation/stratification on.}

\item{\code{result_data}}{environment containing $data, a data.frame with the current state of results.}

\item{\code{current_stratification_characteristic}}{named list with column name and levels of characteristic to stratify by.}

\item{\code{remaining_stratification_characteristics}}{named list with column names and levels of characteristics to stratify by.}

\item{\code{value_column}}{character column with values to calculate percentiles on}

\item{\code{output_column}}{character column to write calculated percentile values to}

\item{\code{use.na}}{logical indicating whether or not NA/non-listed stratification values should be included as a separate group}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `Stratified_percentile_calculator` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-divide_and_calculate"></a>}}
\if{latex}{\out{\hypertarget{method-divide_and_calculate}{}}}
\subsection{Method \code{divide_and_calculate()}}{
recursively calculate stratified percentiles on data.frame
Updates following private fields:
- ..result_data$data
- ::sub_results
- ..current_stratification_characteristic
- ..remaining_stratification_characteristics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stratified_percentile_calculator_generator$divide_and_calculate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
void, but updates ..result_data field
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stratified_percentile_calculator_generator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
