% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.mixed.R
\name{model_performance.merMod}
\alias{model_performance.merMod}
\title{Performance of Mixed Models}
\usage{
\method{model_performance}{merMod}(model, metrics = "all", ...)
}
\arguments{
\item{model}{Object of class \code{merMod}, \code{glmmTMB}, \code{lme} or \code{MixMod}.}

\item{metrics}{Can be \code{"all"} or a character vector of metrics to be computed (some of \code{c("AIC", "BIC", "R2", "ICC", "RMSE")}).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame (with one row) and one column per "index" (see \code{metrics}).
}
\description{
Compute indices of model performance for mixed models.
}
\examples{
library(lme4)
model <- lmer(Petal.Length ~ Sepal.Length + (1 | Species), data = iris)
model_performance(model)

}
