% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_distribution.R
\name{check_distribution}
\alias{check_distribution}
\title{Classify the distribution of a model-family using machine learning}
\usage{
check_distribution(model)
}
\arguments{
\item{model}{A model (that should response to \code{residuals()}).}
}
\description{
Choosing the right distributional family for regression models is essential to get more accurate estimates and standard errors. This function may help to check a models' distributional family and see if the model-family probably should be reconsidered. Since it is difficult to exactly predict the correct model family, consider this function as somewhat experimental.
}
\details{
This function uses an internal random forest model to classify the distribution from a model-family.
}
\note{
This function is somewhat experimental and might be improved in future releases.
  The final decision on the model-family should also be based on theoretical
  aspects and other information about the data and the model.
}
\examples{
library(lme4)
model <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
check_distribution(model)

}
