% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.R
\name{model_performance}
\alias{model_performance}
\alias{compare_performance}
\title{Model Performance}
\usage{
model_performance(model, ...)

compare_performance(..., metrics = "all")
}
\arguments{
\item{model}{Statistical model.}

\item{...}{Arguments passed to or from other methods, resp. for
\code{compare_performance()}, one or multiple model objects (also of
different classes).}

\item{metrics}{Can be \code{"all"} or a character vector of metrics to be computed.
See related documentation of object's class for details.}
}
\value{
For \code{model_performance()}, a data frame (with one row) and one
  column per "index" (see \code{metrics}). For \code{compare_performance()},
  the same data frame with one row per model.
}
\description{
See the documentation for your object's class:
\link[=model_performance.merMod]{mixed models},
\link[=model_performance.stanreg]{Bayesian models} and
\link[=model_performance.lm]{all other models}.
\code{compare_performance()} computes indices of model performance for
different models at once and hence allows comparison of indices accros models.
}
\details{
If all models are of the same class, \code{compare_performance()}
  returns an additional column named \code{BF}, which shows the Bayes factor
  (see \code{\link[bayestestR]{bayesfactor_models}}) for each model against
  the denominator model. The \emph{first} model is used as denominator model,
  and its Bayes factor is set to \code{NA} to indicate the reference model.
}
\examples{
library(lme4)

m1 <- lm(mpg ~ wt + cyl, data = mtcars)
model_performance(m1)

m2 <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
m3 <- lmer(Petal.Length ~ Sepal.Length + (1 | Species), data = iris)
compare_performance(m1, m2, m3)

data(iris)
lm1 <- lm(Sepal.Length ~ Species, data = iris)
lm2 <- lm(Sepal.Length ~ Species + Petal.Length, data = iris)
lm3 <- lm(Sepal.Length ~ Species * Petal.Length, data = iris)
compare_performance(lm1, lm2, lm3)

}
