% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2_loo.R
\name{r2_loo}
\alias{r2_loo}
\title{LOO-adjusted R2}
\usage{
r2_loo(model)
}
\arguments{
\item{model}{A Bayesian regression model.}
}
\value{
The LOO-adjusted R2 for \code{model}, as numeric value.
}
\description{
Compute LOO-adjusted R2.
}
\details{
Unlike \code{\link{r2_bayes}}, which returns an "unadjusted" R2 value,
  \code{r2_loo()} calculates a LOO-adjusted R2, which comes conceptionally
  closer to an "adjusted" R2 measure.
}
\examples{
if (require("rstanarm")) {
  model <- stan_glm(mpg ~ wt + cyl, data = mtcars, chains = 1, iter = 500, refresh = 0)
  r2_loo(model)
}
}
