% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadFile.R
\name{downloadFile}
\alias{downloadFile}
\title{downloadFile Module}
\usage{
downloadFile(..., logger, filenameroot, datafxns = list(), aspectratio = 1)
}
\arguments{
\item{...}{free parameters list for shiny to pass session variables based on the module call(session, input, output)
variables. \emph{Note}: The first argument of this function must be the ID of the Module's UI element}

\item{logger}{logger to use}

\item{filenameroot}{the base text used for user-downloaded file - can be
either a character string or a reactive expression that returns a character
string}

\item{datafxns}{a \strong{named} list of functions providing the data as
return values.  The names for the list should be the same names that were used
when the button UI was created.}

\item{aspectratio}{the downloaded chart image width:height ratio (ex:
1 = square, 1.3 = 4:3, 0.5 = 1:2). Where not applicable for a download type
it is ignored (e.g. data downloads).}
}
\description{
Server-side function for the downloadFileButton.  This is a custom
high-functionality button for file downloads supporting single or multiple
download types.  The server function is used to provide the data for download.
}
\section{Shiny Usage}{

This function is not called directly by consumers - it is accessed in
server.R using the same id provided in \code{downloadFileButton}:

\strong{\code{downloadFile(id, logger, filenameroot, datafxns)}}
}

\examples{
# Inside server_local.R

#single download type
# downloadFile("object_id1", 
#              logger = ss_userAction.Log,
#              filenameroot = "mydownload1",
#              datafxns = list(csv = mydatafxn1),
#              aspectratio = 1)

#multiple download types
# downloadFile("object_id2",
#              logger = ss_userAction.Log,
#              filenameroot = "mytype2",
#              datafxns = list(csv = mydatafxn1, xlsx = mydatafxn2),
#              aspectratio = 1)

}
\seealso{
\link[periscope]{downloadFileButton}

\link[periscope]{downloadFile_ValidateTypes}

\link[periscope]{downloadFile_AvailableTypes}
}
