% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_esem_model.R
\name{make_esem_model}
\alias{make_esem_model}
\title{Make ESEM Model.}
\usage{
make_esem_model(loadings, anchors)
}
\arguments{
\item{loadings}{Dataframe with three columns from exploratory factor
analysis (EFA):
\itemize{
  \item \code{latent} = name of the latent factor(s)
  \item \code{item} = name of the item(s)/indicator(s)
  \item \code{loading} = parameter estimate of the factor loading item
  factor loading on the latent factor
}}

\item{anchors}{Dataframe whose names are the latent factors and whose values
are the names of the anchor item for each latent factor.}
}
\value{
\code{lavaan} model syntax.
}
\description{
Make \code{lavaan} syntax for exploratory structural equation model (ESEM).
}
\details{
Makes syntax for exploratory structural equation model (ESEM) to be fit in
\code{lavaan}.
}
\examples{
# Prepare Data
data("HolzingerSwineford1939", package = "lavaan")

# Specify EFA Syntax
efa_syntax <- '
  # EFA Factor Loadings
  efa("efa1")*f1 +
  efa("efa1")*f2 +
  efa("efa1")*f3 =~ x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8 + x9
'

# Fit EFA Model
mplusRotationArgs <- list(rstarts = 30,
  row.weights = "none",
  algorithm = "gpa",
  orthogonal = FALSE,
  jac.init.rot = TRUE,
  std.ov = TRUE, # row standard = correlation
  geomin.epsilon = 0.0001)

efa_fit <- lavaan::sem(
  efa_syntax,
  data = HolzingerSwineford1939,
  information = "observed",
  missing = "ML",
  estimator = "MLR",
  rotation = "geomin",
  # mimic Mplus
  meanstructure = TRUE,
  rotation.args = mplusRotationArgs)

# Extract Factor Loadings
esem_loadings <- lavaan::parameterEstimates(
  efa_fit,
  standardized = TRUE
) |>
  dplyr::filter(efa == "efa1") |>
  dplyr::select(lhs, rhs, est) |>
  dplyr::rename(item = rhs, latent = lhs, loading = est)

# Specify Anchor Item for Each Latent Factor
anchors <- c(f1 = "x3", f2 = "x5", f3 = "x7")

# Generate ESEM Syntax
esemModel_syntax <- make_esem_model(esem_loadings, anchors)

# Fit ESEM Model
lavaan::sem(
  esemModel_syntax,
  data = HolzingerSwineford1939,
  missing = "ML",
  estimator = "MLR")

}
\seealso{
\url{https://msilvestrin.me/post/esem/}

Other structural equation modeling: 
\code{\link{equiv_chi}()},
\code{\link{puc}()},
\code{\link{satorraBentlerScaledChiSquareDifferenceTestStatistic}()}
}
\concept{lavaan}
\concept{structural equation modeling}
