/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.fonts;

import java.util.ArrayList;
import java.util.List;
import net.sf.eps2pgf.ProgramError;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorInvalidFont;
import net.sf.eps2pgf.ps.errors.PSErrorTypeCheck;
import net.sf.eps2pgf.ps.errors.PSErrorUndefined;
import net.sf.eps2pgf.ps.errors.PSErrorUnimplemented;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.fonts.Type1;
import net.sf.eps2pgf.ps.resources.fonts.Type3;
import org.fontbox.afm.FontMetric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSObjectFontMetrics
extends PSObject
implements Cloneable {
    private FontMetric fontMetrics;
    private List<List<PSObject>> subrs;

    public PSObjectFontMetrics(FontMetric fontMetric, List<List<PSObject>> list) {
        this.fontMetrics = fontMetric;
        this.subrs = list;
    }

    public PSObjectFontMetrics(FontMetric fontMetric) {
        this.fontMetrics = fontMetric;
        this.subrs = new ArrayList<List<PSObject>>();
    }

    public PSObjectFontMetrics(PSObjectDict pSObjectDict) throws PSError, ProgramError {
        int n;
        try {
            n = pSObjectDict.get("FontType").toInt();
        }
        catch (PSErrorUndefined pSErrorUndefined) {
            throw new PSErrorInvalidFont("FontType is not defined.");
        }
        catch (PSErrorTypeCheck pSErrorTypeCheck) {
            throw new PSErrorInvalidFont("FontType is not an integer.");
        }
        switch (n) {
            case 1: {
                Type1.load(this, pSObjectDict);
                break;
            }
            case 3: {
                Type3.load(this, pSObjectDict);
                break;
            }
            default: {
                throw new PSErrorUnimplemented("type " + n + " fonts");
            }
        }
    }

    @Override
    public PSObjectFontMetrics clone() {
        PSObjectFontMetrics pSObjectFontMetrics = (PSObjectFontMetrics)super.clone();
        pSObjectFontMetrics.fontMetrics = this.fontMetrics;
        pSObjectFontMetrics.subrs = this.subrs;
        return new PSObjectFontMetrics(this.fontMetrics, this.subrs);
    }

    @Override
    public PSObjectFontMetrics dup() {
        PSObjectFontMetrics pSObjectFontMetrics = new PSObjectFontMetrics(this.fontMetrics, this.subrs);
        pSObjectFontMetrics.copyCommonAttributes(this);
        return pSObjectFontMetrics;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PSObject) {
            return this.eq((PSObject)object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.isis().hashCode();
    }

    @Override
    public FontMetric toFontMetric() {
        return this.fontMetrics;
    }

    public FontMetric getFontMetrics() {
        return this.fontMetrics;
    }

    public void setFontMetrics(FontMetric fontMetric) {
        this.fontMetrics = fontMetric;
    }

    public List<List<PSObject>> getSubrs() {
        return this.subrs;
    }

    public void setSubrs(List<List<PSObject>> list) {
        this.subrs = list;
    }
}

