% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{header_height}
\alias{header_height}
\alias{header_height<-}
\alias{set_header_height}
\alias{footer_height}
\alias{footer_height<-}
\alias{set_footer_height}
\title{Return or set header/footer height}
\usage{
header_height(x, ...)

header_height(x) <- value

set_header_height(x, value)

footer_height(x, ...)

footer_height(x) <- value

set_footer_height(x, value)
}
\arguments{
\item{x}{A \code{rtf_doc} object}

\item{...}{Additonal arguments passed to method dispatch}

\item{value}{A numeric value to set the header_height/footer_height}
}
\value{
For \code{header_height()}/\code{footer_height()}, the
  header_height/footer_height attribute of thesupplied \code{rtf_doc}
  object. For \code{`header_height<-()`}/ \code{`footer_height<-`()} and
  \code{set_header_height()}/ \code{set_footer_height()}, the modified
  object.
}
\description{
These property functions modify or return the header_height/footer_height attribute
of a \code{rtf_doc} object. The header/footer height is the default amount of
space allocated to the header/footer from the margin. If the content of the
header/footer exceeds this amount of space, it will be expanded.
}
\examples{
library(huxtable)
ht <- huxtable(
  column1 = 1:5,
  column2 = letters[1:5]
)
rtf <- rtf_doc(ht, list(hf_line("aTitle")))

header_height(rtf)
# Returns 0.5, the default

footer_height(rtf) <- 1
# Sets footer_height to 1

}
