% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indPeriodogramAct.R
\name{indPeriodogramAct}
\alias{indPeriodogramAct}
\title{Periodogram plot for activity data of individual flies}
\usage{
indPeriodogramAct(
  data,
  bin = 1,
  method = "ChiSquare",
  low.per = 16,
  high.per = 32,
  alpha = 0.05,
  time.res = 20,
  ind = 1
)
}
\arguments{
\item{data}{Input data file. If the method for analysis is "ChiSquare", then the input for this function must be the output of the function trimData(). See ??trimData(). Otherwise, the input for this function must be the output of the function binData(). See ??binData().}

\item{bin}{Intervals in which data are sampled (in minutes). This defaults to 1. This must be changed appropriately depending on method of analysis and the input data set.}

\item{method}{Choose the method for performing time-series analysis. Currently, three methods are implemented for analysis - "ChiSquare", "Autocorrelation", and "LombScargle". This defaults to "ChiSquare".}

\item{low.per}{Choose the lowest period (in hours) for analysis. This defaults to 16.}

\item{high.per}{Choose the highest period (in hours) for analysis. This defaults to 32.}

\item{alpha}{Choose the significance level for periodogram analysis. This defaults to 0.05.}

\item{time.res}{Resolution of periods (in minutes) to analyse while using the ChiSquare periodogram. For instance, if users wish to scan periods from low.per to high.per in the following manner: 16, 16.5, 17, 17.5, and so on, then time.res must be 30. This defaults to 20.}

\item{ind}{The channel number (or individual) whose periodogram must be plotted.}
}
\value{
A \code{plotly} \code{htmlwidget} with the individual periodogram of a user defined fly.
}
\description{
This function generates a periodogram for the activity data of a single fly. Input for this function must be an output from the trimData() function. The output of this function is a plotly object.
}
\examples{
td <- trimData(data = df, start.date = "19 Dec 20", start.time = "21:00",
n.days = 10, bin = 1, t.cycle = 24)
ind.periodogram.act <- indPeriodogramAct(data = td, ind = 13)
}
