% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_input.R
\name{check_input}
\alias{check_input}
\title{check_input}
\usage{
check_input(
  t,
  y,
  w,
  QC_flag,
  nptperyear,
  south = FALSE,
  Tn = NULL,
  wmin = 0.2,
  wsnow = 0.8,
  ymin,
  missval,
  maxgap,
  alpha = 0.02,
  alpha_high = NULL,
  date_start = NULL,
  date_end = NULL,
  mask_spike = TRUE,
  ...
)
}
\arguments{
\item{t}{Numeric vector, \code{Date} variable}

\item{y}{Numeric vector, vegetation index time-series}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified,
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{QC_flag}{Factor (optional) returned by \code{qcFUN}, levels should be
in the range of \code{c("snow", "cloud", "shadow", "aerosol", "marginal", "good")}, others will be categoried into \code{others}. \code{QC_flag} is
used for visualization in \code{\link[=get_pheno]{get_pheno()}} and \code{\link[=plot_curvefits]{plot_curvefits()}}.}

\item{nptperyear}{Integer, number of images per year.}

\item{south}{Boolean. In south hemisphere, growing year is 1 July to the
following year 31 June; In north hemisphere, growing year is 1 Jan to 31 Dec.}

\item{Tn}{Numeric vector, night temperature, default is null. If provided,
Tn is used to help divide ungrowing period, and then get background value in
ungrowing season (see details in \code{\link[=backval]{backval()}}).}

\item{wmin}{Double, minimum weight of bad points, which could be smaller
the weight of snow, ice and cloud.}

\item{wsnow}{Doulbe. Reset the weight of snow points, after get \code{ylu}.
Snow flag is an important flag of ending of growing
season. Snow points is more valuable than marginal points. Hence, the weight
of snow should be great than that of \code{marginal}.}

\item{ymin}{If specified, \code{ylu[1]} is constrained greater than ymin. This
value is critical for bare, snow/ice land, where vegetation amplitude is quite
small. Generally, you can set ymin=0.08 for NDVI, ymin=0.05 for EVI,
ymin=0.5 gC m-2 s-1 for GPP.}

\item{missval}{Double, which is used to replace NA values in y. If missing,
the default vlaue is \code{ylu[1]}.}

\item{maxgap}{Integer, nptperyear/4 will be a suitable value. If continuous
missing value numbers less than maxgap, then interpolate those NA values by
zoo::na.approx; If false, then replace those NA values with a constant value
\code{ylu[1]}. \cr
Replacing NA values with a constant missing value (e.g. background value ymin)
is inappropriate for middle growing season points. Interpolating all values
by na.approx, it is unsuitable for large number continous missing segments,
e.g. in the start or end of growing season.}

\item{alpha}{Double, in \verb{[0,1]}, quantile prob of ylu_min.}

\item{alpha_high}{Double, \verb{[0,1]}, quantile prob of \code{ylu_max}. If not
specified, \code{alpha_high=alpha}.}

\item{date_start, date_end}{starting and ending date of the original vegetation
time-sereis (before \code{add_HeadTail})}

\item{mask_spike}{Boolean. Whether to remove spike values?}

\item{...}{Others will be ignored.}
}
\value{
A list object returned:
\itemize{
\item \code{t} : Numeric vector
\item \code{y0}: Numeric vector, original vegetation time-series.
\item \code{y} : Numeric vector, checked vegetation time-series, \code{NA} values are interpolated.
\item \code{w} : Numeric vector
\item \code{Tn}: Numeric vector
\item \code{ylu}: = \verb{[ymin, ymax]}. \code{w_critical} is used to filter not too bad values.

If the percentage good values (w=1) is greater than 30\\%, then \code{w_critical}=1.

The else, if the percentage of w >= 0.5 points is greater than 10\\%, then
\code{w_critical}=0.5. In boreal regions, even if the percentage of w >= 0.5
points is only 10\\%, we still can't set \code{w_critical=wmin}.

We can't rely on points with the wmin weights. Then,  \cr
\code{y_good = y[w >= w_critical]},  \cr
\code{ymin = pmax( quantile(y_good, alpha/2), 0)}  \cr \code{ymax = max(y_good)}.
}
}
\description{
Check input data, interpolate NA values in y, remove spike values, and set
weights for NA in y and w.
}
\examples{
data("CA_NS6")
d = CA_NS6
head(d)

nptperyear <- 23
INPUT <- check_input(d$t, d$y, d$w, QC_flag = d$QC_flag,
     nptperyear = nptperyear, south = FALSE, 
     maxgap = nptperyear/4, alpha = 0.02, wmin = 0.2)
plot_input(INPUT)
}
\seealso{
\code{\link[=backval]{backval()}}
}
