% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_Gratiot_mcmc.R
\docType{data}
\name{result_Gratiot_mcmc}
\alias{result_Gratiot_mcmc}
\title{Result of the mcmc for Leatherback nest counts}
\format{
A mcmcComposite object with mcmc result.
}
\usage{
result_Gratiot_mcmc
}
\description{
Result of the mcmc for Leatherback nest counts from Gratiot et al. (2006) Figure 1
The phenology has been fitted with MinE, MinB, Max, Flat, LengthB, LengthE, Peak, Theta.
}
\details{
Result of the mcmc for Leatherback nest counts from Gratiot et al. (2006) Figure 1
}
\examples{
\dontrun{
library(phenology)
data(result_Gratiot)
# Read a file with data
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
data_Gratiot <- add_phenology(Gratiot, name="Complete", 
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg <- par_init(data_Gratiot, fixed.parameters=NULL)
# Run the optimisation
result_Gratiot <- fit_phenology(data=data_Gratiot, 
		fitted.parameters=parg, fixed.parameters=NULL)
# generate data for mcmc run
pmcmc <- phenology_MHmcmc_p(result_Gratiot, accept = TRUE)
result_Gratiot_mcmc <- phenology_MHmcmc(result = result_Gratiot, 
     n.iter = 10000, 
     adaptive=TRUE,
     parametersMCMC = pmcmc, 
     n.chains = 1, n.adapt = 0, thin = 1, trace = FALSE)
# Read a file with result
data(result_Gratiot_mcmc)
1-rejectionRate(as.mcmc(result_Gratiot_mcmc))

summary(result_Gratiot, resultmcmc=result_Gratiot_mcmc)
}
}
\references{
Gratiot, N., Gratiot, J., de Thoisy, B. & Kelle, L. 2006.
Estimation of marine turtles nesting season from incomplete
data ; statistical adjustment of a sinusoidal function. Animal
Conservation, 9, 95-102.
}
\seealso{
Other Phenology model: 
\code{\link{AutoFitPhenology}()},
\code{\link{BE_to_LBLE}()},
\code{\link{Gratiot}},
\code{\link{LBLE_to_BE}()},
\code{\link{LBLE_to_L}()},
\code{\link{L_to_LBLE}()},
\code{\link{MarineTurtles_2002}},
\code{\link{MinBMinE_to_Min}()},
\code{\link{adapt_parameters}()},
\code{\link{add_SE}()},
\code{\link{add_phenology}()},
\code{\link{extract_result}()},
\code{\link{fit_phenology}()},
\code{\link{likelihood_phenology}()},
\code{\link{logLik.phenology}()},
\code{\link{map_Gratiot}},
\code{\link{map_phenology}()},
\code{\link{par_init}()},
\code{\link{phenology}()},
\code{\link{phenology2fitRMU}()},
\code{\link{phenology_MHmcmc}()},
\code{\link{phenology_MHmcmc_p}()},
\code{\link{plot.phenology}()},
\code{\link{plot.phenologymap}()},
\code{\link{plot_delta}()},
\code{\link{plot_phi}()},
\code{\link{print.phenology}()},
\code{\link{print.phenologymap}()},
\code{\link{print.phenologyout}()},
\code{\link{remove_site}()},
\code{\link{result_Gratiot}},
\code{\link{result_Gratiot1}},
\code{\link{result_Gratiot2}},
\code{\link{result_Gratiot_Flat}},
\code{\link{summary.phenology}()},
\code{\link{summary.phenologymap}()},
\code{\link{summary.phenologyout}()}
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\concept{Phenology model}
\keyword{datasets}
