#' Likelihood map of Leatherback nest counts from Gratiot et al. (2006) Figure 1
#' @title Likelihood map of Leatherback nest counts
#' @author Marc Girondot \email{marc.girondot@@u-psud.fr}
#' @docType data
#' @name map_Gratiot
#' @description Likelihood map of Leatherback nest counts from Gratiot et al. (2006) Figure 1.
#' A intraseasonal periodic pattern was searched for varying Phi and Delta parameters.
#' @references Gratiot, N., Gratiot, J., de Thoisy, B. & Kelle, L. 2006. 
#'             Estimation of marine turtles nesting season from incomplete 
#'             data ; statistical adjustment of a sinusoidal function. Animal 
#'             Conservation, 9, 95-102.
#' @keywords datasets
#' @usage map_Gratiot
#' @examples
#' library(phenology)
#' # Read a file with likelihood map
#' data(map_Gratiot)
#' @format A list with Gratiot data and the result of the fit.
NULL
