% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPPredict.R
\name{IPPredict}
\alias{IPPredict}
\title{Predict the possible clutch number based on observed Internesting Period.}
\usage{
IPPredict(x = NULL, par = NULL, N = NULL, IP = 0:100)
}
\arguments{
\item{x}{A result of IPFit().}

\item{par}{A set of parameters.}

\item{N}{Number of replicates}

\item{IP}{A vector of Internesting Period}
}
\value{
A data.frame
}
\description{
This function predicts the possible clutch number 
based on observed Internesting Period.\cr
}
\details{
IPPredict calculates the possible clutch number based on observed Internesting Period.
}
\examples{
\dontrun{
library(phenology)
# Example
######### Fit using Maximum-Likelihood

par <- c(meanIP = 9.9959691992722917, 
         sdIP = 0.10066664270893474, 
         minIP = 7.5684588178888754, 
         pAbort = 2.2510012544630911, 
         meanAbort = 2.8969185085603386, 
         sdAbort = 0.92688983853803242, 
         pCapture = -1.0393803705929086, 
         meanECF = 3.9551519427394255, 
         sdECF = 0.31657679943365019)

IPPredict(par=par, IP=c(10, 80))

}
}
\seealso{
Other Model of Internesting Period: \code{\link{IPFit}},
  \code{\link{IPModel}}, \code{\link{plot.IP}},
  \code{\link{summary.IP}}
}
\author{
Marc Girondot
}
