\name{spectralslice}
\alias{spectralslice}
\alias{slice}
\title{
Spectral Slice
}
\description{
A function to plot the power spectrum of a vector representing a sound wave. 
}
\usage{
spectralslice (sound, padding = length(sound) * 2, fs = 1,  
show = TRUE, add = FALSE, window = "kaiser", 
windowparameter = 3, zeromax = TRUE, preemphasisf = 0, type, 
line = FALSE, removeDC = TRUE, ...)
}
\arguments{
  \item{sound}{A vector representing a sound wave, or a 'sound' object.}
  \item{padding}{The amount of zero-padding desired for the analysis, in number of samples.}
  \item{fs}{The sampling frequency of the sound. If a 'sound' object is passed this does not need to be specified.}
  \item{show}{If FALSE, no plot is created.}
  \item{add}{If TRUE, the spectrum is added to an existing plot. If FALSE a new one is created.}
  \item{window}{The window to be applied to the signal, applied by windowfunc(), provided in this package.}
  \item{windowparameter}{The parameter for the window to be applied to the signal, if appropriate. Passed to windowfunc().}
  \item{zeromax}{If TRUE, the maximum dB is set to 0.}
  \item{type}{The line type to be used for plotting, passes its value to the 'lty' parameter.}
  \item{preemphasisf}{Preemphasis of 3 dB per octave is added to frequencies above the specified frequency.}
  \item{line}{If TRUE, a line spectrum is created.}
  \item{removeDC}{If TRUE, the DC component is removed.}
  \item{\dots}{any additional arguments will be passed to the internal calls of 'plot' or 'lines'.}
}
\value{
A dataframe with the following elements is returned:

\item{hz}{The center frequency of the analysis bins.}
\item{dB}{The dB magnitude/power for the analysis bin.}
}
\author{
Santiago Barreda <sbarreda@ucdavis.edu>
}
\examples{

## synthesize schwa-like vowel 
vowel = vowelsynth (ffs = c(500,1500,2500,3500,4500))$sound
    
## compare window lengths
par (mfrow = c(3,1))
spectralslice (vowel[500:550], fs = 10000)
spectralslice (vowel[500:1000], fs = 10000)
     
## line spectrum
spectralslice (vowel[500:600], padding = 0, line = TRUE, fs = 10000)

}
