library(phonenumber)
context("numberToLetter")

test_that("numberToLetter returns the correct letters", {
    expect_equal(numberToLetter("2"), c("A", "B", "C"))
    expect_equal(numberToLetter("3"), c("D", "E", "F"))
    expect_equal(numberToLetter("4"), c("G", "H", "I"))
    expect_equal(numberToLetter("5"), c("J", "K", "L"))
    expect_equal(numberToLetter("6"), c("M", "N", "O"))
    expect_equal(numberToLetter("7"), c("P", "Q", "R", "S"))
    expect_equal(numberToLetter("7", qz = 0), c("P", "R", "S"))
    expect_equal(numberToLetter("8"), c("T", "U", "V"))
    expect_equal(numberToLetter("9"), c("W", "X", "Y", "Z"))
    expect_equal(numberToLetter("9", qz = 0), c("W", "X", "Y"))
    expect_equal(numberToLetter("1"), "1")
    expect_equal(numberToLetter("0"), "0")
    expect_equal(numberToLetter("0", qz = 0), c("Q", "Z"))
    expect_equal(numberToLetter("-"), "-")
    expect_equal(numberToLetter("#"), "-")
    expect_equal(numberToLetter("!"), "-")
    expect_equal(numberToLetter(" "), "-")
    expect_equal(numberToLetter("911!"), c("W11-", "X11-", "Y11-", "Z11-"))    
    expect_equal(numberToLetter("000"), "000")
    expect_equal(numberToLetter("000", qz = 0), c("QQQ", "QQZ", "QZQ", "QZZ", 
                                                  "ZQQ", "ZQZ", "ZZQ", "ZZZ"))
})