% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zmspct.classes.R
\name{as.chroma_mspct}
\alias{as.chroma_mspct}
\alias{as.chroma_mspct.default}
\alias{as.chroma_mspct.data.frame}
\alias{as.chroma_mspct.chroma_spct}
\alias{as.chroma_mspct.list}
\title{Coerce to a collection-of-spectra}
\usage{
as.chroma_mspct(x, ...)

\method{as.chroma_mspct}{default}(x, ...)

\method{as.chroma_mspct}{data.frame}(x, ...)

\method{as.chroma_mspct}{chroma_spct}(x, ...)

\method{as.chroma_mspct}{list}(x, ..., ncol = 1, byrow = FALSE)
}
\arguments{
\item{x}{a list of spectral objects or a list of objects such as data frames
that can be converted into spectral objects.}

\item{...}{passed to individual spectrum object constructor}

\item{ncol}{integer Number of 'virtual' columns in data}

\item{byrow}{logical If \code{ncol > 1} how to read in the data}
}
\value{
A copy of \code{x} converted into a \code{chroma_mspct} object.
}
\description{
Return a copy of an R object with its class set to a given type
  of spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{data.frame}: 

\item \code{chroma_spct}: 

\item \code{list}: 
}}

\seealso{
Other Coercion methods for collections of spectra: 
\code{\link{as.calibration_mspct}()},
\code{\link{as.cps_mspct}()},
\code{\link{as.filter_mspct}()},
\code{\link{as.generic_mspct}()},
\code{\link{as.object_mspct}()},
\code{\link{as.raw_mspct}()},
\code{\link{as.reflector_mspct}()},
\code{\link{as.response_mspct}()},
\code{\link{as.solute_mspct}()},
\code{\link{as.source_mspct}()},
\code{\link{split2mspct}()},
\code{\link{subset2mspct}()}
}
\concept{Coercion methods for collections of spectra}
