% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{is.generic_spct}
\alias{is.generic_spct}
\alias{is.raw_spct}
\alias{is.calibration_spct}
\alias{is.cps_spct}
\alias{is.source_spct}
\alias{is.response_spct}
\alias{is.filter_spct}
\alias{is.reflector_spct}
\alias{is.object_spct}
\alias{is.solute_spct}
\alias{is.chroma_spct}
\alias{is.any_spct}
\title{Query class of spectrum objects}
\usage{
is.generic_spct(x)

is.raw_spct(x)

is.calibration_spct(x)

is.cps_spct(x)

is.source_spct(x)

is.response_spct(x)

is.filter_spct(x)

is.reflector_spct(x)

is.object_spct(x)

is.solute_spct(x)

is.chroma_spct(x)

is.any_spct(x)
}
\arguments{
\item{x}{an R object.}
}
\value{
A logical value, \code{TRUE} if the argument passed to \code{x} is an
  object of the queried type of spectrum and \code{FALSE} otherwise.
}
\description{
Functions to query whether an object is of a given type of spectrum.
}
\note{
Derived types also return \code{TRUE} for a query for a base type such
  as \code{generic_spct}, following R's practice.
}
\examples{
is.source_spct(sun.spct)
is.filter_spct(sun.spct)
is.generic_spct(sun.spct)
is.generic_spct(sun.spct)

is.source_spct(sun.spct)
is.filter_spct(sun.spct)
is.generic_spct(sun.spct)
is.generic_spct(sun.spct)

}
