% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.spikes.R
\name{despike}
\alias{despike}
\alias{despike.default}
\alias{despike.numeric}
\alias{despike.data.frame}
\alias{despike.generic_spct}
\alias{despike.source_spct}
\alias{despike.response_spct}
\alias{despike.filter_spct}
\alias{despike.reflector_spct}
\alias{despike.solute_spct}
\alias{despike.cps_spct}
\alias{despike.raw_spct}
\alias{despike.generic_mspct}
\alias{despike.source_mspct}
\alias{despike.response_mspct}
\alias{despike.filter_mspct}
\alias{despike.reflector_mspct}
\alias{despike.solute_mspct}
\alias{despike.cps_mspct}
\alias{despike.raw_mspct}
\title{Remove spikes from spectrum}
\usage{
despike(x, z.threshold, max.spike.width, window.width, method, na.rm, ...)

\method{despike}{default}(
  x,
  z.threshold = NA,
  max.spike.width = NA,
  window.width = NA,
  method = "run.mean",
  na.rm = FALSE,
  ...
)

\method{despike}{numeric}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...
)

\method{despike}{data.frame}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...,
  y.var.name = NULL,
  var.name = y.var.name
)

\method{despike}{generic_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...,
  y.var.name = NULL,
  var.name = y.var.name
)

\method{despike}{source_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...
)

\method{despike}{response_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...
)

\method{despike}{filter_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  ...
)

\method{despike}{reflector_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...
)

\method{despike}{solute_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...
)

\method{despike}{cps_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...
)

\method{despike}{raw_spct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...
)

\method{despike}{generic_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...,
  y.var.name = NULL,
  var.name = y.var.name,
  .parallel = FALSE,
  .paropts = NULL
)

\method{despike}{source_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{despike}{response_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{despike}{filter_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  filter.qty = getOption("photobiology.filter.qty", default = "transmittance"),
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{despike}{reflector_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{despike}{solute_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{despike}{cps_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...,
  .parallel = FALSE,
  .paropts = NULL
)

\method{despike}{raw_mspct}(
  x,
  z.threshold = 9,
  max.spike.width = 8,
  window.width = 11,
  method = "run.mean",
  na.rm = FALSE,
  ...,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{an R object}

\item{z.threshold}{numeric Modified Z values larger than \code{z.threshold}
are considered to correspond to spikes.}

\item{max.spike.width}{integer Wider regions with high Z values are not detected as
spikes.}

\item{window.width}{integer. The full width of the window used for the
running mean used as replacement.}

\item{method}{character The name of the method: \code{"run.mean"} is running
mean as described in Whitaker and Hayes (2018); \code{"adj.mean"} is mean
of adjacent neighbors (isolated bad pixels only).}

\item{na.rm}{logical indicating whether \code{NA} values should be treated
as spikes and replaced.}

\item{...}{Arguments passed by name to \code{find_spikes()}.}

\item{var.name, y.var.name}{character Names of columns where to look
for spikes to remove.}

\item{unit.out}{character One of "energy" or "photon"}

\item{filter.qty}{character One of "transmittance" or "absorbance"}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
\code{x} with rows corresponding to spikes replaced by a local
  average of adjacent neighbors outside the spike.
}
\description{
Function that returns an R object with observations corresponding to spikes
replaced by values computed from neighboring pixels. Spikes are values in
spectra that are unusually high compared to neighbors. They are usually
individual values or very short runs of similar "unusual" values. Spikes
caused by cosmic radiation are a frequent problem in Raman spectra. Another
source of spikes are "hot pixels" in CCD and diode array detectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{despike(default)}: Default returning always NA.

\item \code{despike(numeric)}: Default function usable on numeric vectors.

\item \code{despike(data.frame)}: Method for "data.frame" objects.

\item \code{despike(generic_spct)}: Method for "generic_spct" objects.

\item \code{despike(source_spct)}: Method for "source_spct" objects.

\item \code{despike(response_spct)}: Method for "response_spct" objects.

\item \code{despike(filter_spct)}: Method for "filter_spct" objects.

\item \code{despike(reflector_spct)}: Method for "reflector_spct" objects.

\item \code{despike(solute_spct)}: Method for "solute_spct" objects.

\item \code{despike(cps_spct)}: Method for "cps_spct" objects.

\item \code{despike(raw_spct)}: Method for "raw_spct" objects.

\item \code{despike(generic_mspct)}: Method for "generic_mspct" objects.

\item \code{despike(source_mspct)}: Method for "source_mspct" objects.

\item \code{despike(response_mspct)}: Method for "cps_mspct" objects.

\item \code{despike(filter_mspct)}: Method for "filter_mspct" objects.

\item \code{despike(reflector_mspct)}: Method for "reflector_mspct" objects.

\item \code{despike(solute_mspct)}: Method for "solute_mspct" objects.

\item \code{despike(cps_mspct)}: Method for "cps_mspct" objects.

\item \code{despike(raw_mspct)}: Method for "raw_mspct" objects.

}}
\note{
Current algorithm misidentifies steep smooth slopes as spikes, so
  manual inspection is needed together with adjustment by trial and error
  of a suitable argument value for \code{z.threshold}.
}
\examples{

white_led.raw_spct[120:125, ]

# find and replace spike at 245.93 nm
despike(white_led.raw_spct,
        z.threshold = 10,
        window.width = 25)[120:125, ]

}
\seealso{
See the documentation for \code{\link{find_spikes}} and
  \code{\link{replace_bad_pixs}} for details of the algorithm and
  implementation.
}
\concept{despike and valleys functions}
